const mix = require('laravel-mix');

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */
mix.copy('resources/images', 'public/images');
mix.copy('resources/fontawesome/webfonts', 'public/webfonts');
mix.css('resources/fontawesome/all.min.css', 'public/css/icons.css').options({
    processCssUrls: false
});

mix.js('resources/js/app.js', 'public/js');
mix.js('resources/js/argon.js', 'public/js');
mix.sass('resources/assets/scss/argon.scss', 'public/css');

mix.extract(['jquery'], 'public/js/vendor_jquery.js');
mix.extract(['bootstrap', 'popper.js'], 'public/js/vendor_admin.js');

mix.sourceMaps();
mix.version();
