<div class="col-sm-5 col-md-4 mb-4 form-group">
    <?php if(admin()?->picture): ?>
        <img src="<?php echo e(admin()?->avatar_path); ?>" class="rounded-circle img-thumbnail">
    <?php else: ?>
        <img src="<?php echo e(uno()->avatar); ?>" class="rounded-circle img-thumbnail">
    <?php endif; ?>
</div>
<div class="col-12 form-group">
    <label class="form-control-label" for="input-name"><?php echo e(__('Name')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('name') ? 'has-danger' : ''); ?>">
        <input type="text" name="name" id="input-name" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Name')); ?>" value="<?php echo e(old('name', admin()?->name)); ?>" required autofocus>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'name'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<div class="col-lg-6 form-group">
    <label class="form-control-label" for="input-email"><?php echo e(__('Email')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('email') ? 'has-danger' : ''); ?>">
        <input type="email" name="email" id="input-email" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Email')); ?>" value="<?php echo e(old('email', admin()?->email)); ?>" required autocomplete="new-email">
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'email'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<div class="col-lg-6 form-group">
    <label class="form-control-label" for="input-contact_no"><?php echo e(__('Contact No.')); ?></label>
    <div class="<?php echo e($errors->has('contact_no') ? 'has-danger' : ''); ?>">
        <input type="tel" inputmode="numeric" name="contact_no"  id="input-contact_no" class="form-control <?php echo e($errors->has('contact_no') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Contact No.')); ?>" value="<?php echo e(old('contact_no', admin()?->contact_no)); ?>">
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'contact_no'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<?php echo $__env->make('admin.components.fileinput', ['label' => 'Image', 'name' => 'photo', 'elfinder' => true], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Admin/Resources/views/profile/form.blade.php ENDPATH**/ ?>