<?php $setting_entity = app(App\Model\Setting::class); ?>



<?php $__env->startSection('header'); ?>
    <?php $__env->startComponent('admin.layouts.headers.breadcrumbs'); ?>
        <?php $__env->slot('title'); ?>
            <i class="fas fa-tools fa-lg"></i>
        <?php $__env->endSlot(); ?>

        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Settings')); ?></li>
    <?php echo $__env->renderComponent(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                <?php if(app()->isDownForMaintenance()): ?>
                    <div class="alert alert-secondary shadow mb-4" role="alert">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-circle-exclamation text-danger fa-lg"></i>
                            <strong class="px-3"><?php echo e(__('MAINTENANCE MODE')); ?>:</strong>
                            <?php if(config('app.maintenance_mode_message')): ?>
                                <strong class="pr-3 mr-auto">[ <?php echo e(config('app.maintenance_mode_message')); ?> ]</strong>
                            <?php endif; ?>
                            <span class="badge badge-pill badge-success badge-lg"><?php echo e(__('ENABLED')); ?></span>
                        </div>
                    </div>
                <?php endif; ?>
                <form action="<?php echo e(route('setting.update')); ?>" method="post" autocomplete="off" enctype="multipart/form-data">
                    <?php echo method_field('put'); ?>
                    <?php echo csrf_field(); ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card card-form shadow">
                                <div class="card-body text-center">
                                    <button type="submit" class="btn btn-success px-5"><i class="fas fa-save mr-2"></i><?php echo e(__('Save All')); ?></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <?php echo $__env->make('admin.setting.module.general', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make('admin.setting.module.smtp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>
                        <div class="col-xl-6">
                            <?php echo $__env->make('admin.setting.module.recaptcha', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make('admin.setting.module.maintenance', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make('admin.setting.module.other', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>
                        <div class="col-12">
                            <div class="card card-form shadow">
                                <div class="card-body text-center">
                                    <button type="submit" class="btn btn-success px-5"><i class="fas fa-save mr-2"></i><?php echo e(__('Save All')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('vendor-css'); ?>
    <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/select2/dist/css/select2.min.css')); ?>" nonce="<?php echo e(csp_nonce('style')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('vendor-js'); ?>
    <script src="<?php echo e(basset_url('argon/vendor/select2/dist/js/select2.full.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Settings Management'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/setting/index.blade.php ENDPATH**/ ?>