<?php $__env->startSection('header'); ?>
    <?php if(app()->isDownForMaintenance()): ?>
        <div class="alert alert-secondary shadow mb--3 mt-4" role="alert">
            <div class="d-flex align-items-center">
                <i class="fas fa-circle-exclamation text-danger fa-lg"></i>
                <strong class="px-3"><?php echo e(__('MAINTENANCE MODE')); ?>:</strong>
                <?php if(config('app.maintenance_mode_message')): ?>
                    <strong class="pr-3 mr-auto">[ <?php echo e(config('app.maintenance_mode_message')); ?> ]</strong>
                <?php endif; ?>
                <span class="badge badge-pill badge-success badge-lg"><?php echo e(__('ENABLED')); ?></span>
            </div>
        </div>
    <?php endif; ?>

    <div class="mb--4 mt-4">
        <?php echo $__env->make('alerts.success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php echo $__env->make('alerts.errors', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <div class="row pt-3 mb--6">
        <div class="col-12">
            <h1 class="display-2 text-white mb-3"><?php echo e(__('Modules')); ?></h1>
        </div>

        <?php if(module_enabled('Event')): ?>
            <?php
                $events = \Modules\Event\Entities\Event::latest()->get();
            ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'event.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Events'),
                'query' => $events->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-calendar-day'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'event.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Events'),
                'query' => $events->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-calendar-day'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'event.index',
                'params' => ['featured' => 'yes'],
                'label' => __('Total Featured Events'),
                'query' => $events->where('is_featured', true),
                'color' => 'tertiary',
                'icon' => 'fa-calendar-day'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <?php if(module_enabled('Feedback')): ?>
            <?php
                $feedbacks = \Modules\Feedback\Entities\Feedback::latest()->get();
            ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'feedback.index',
                'params' => ['status' => $status = \Modules\Feedback\Entities\Feedback::STATUS_APPROVED],
                'label' => __('Total Approved Feedbacks'),
                'query' => $feedbacks->where('status', $status),
                'color' => 'success',
                'icon' => 'fa-comments'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'feedback.index',
                'params' => ['status' => $status = \Modules\Feedback\Entities\Feedback::STATUS_DISABLED],
                'label' => __('Total Disabled Feedbacks'),
                'query' => $feedbacks->where('status', $status),
                'color' => 'danger',
                'icon' => 'fa-comments'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'feedback.index',
                'params' => ['status' => $status = \Modules\Feedback\Entities\Feedback::STATUS_PENDING],
                'label' => __('Total Pending Feedbacks'),
                'query' => $feedbacks->where('status', $status),
                'color' => 'tertiary',
                'icon' => 'fa-comments'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <?php if(module_enabled('Announcement')): ?>
            <?php
                $announcements = \Modules\Announcement\Entities\Announcement::latest()->get();
            ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'announcement.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Announcements'),
                'query' => $announcements->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-bullhorn'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'announcement.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Announcements'),
                'query' => $announcements->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-bullhorn'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <div class="col-12">
            <h1 class="display-2 text-white mb-3"><?php echo e(__('Users')); ?></h1>
        </div>

        <?php if(module_enabled('Admin')): ?>
            <?php
                $admins = \Modules\Admin\Entities\Admin::withTrashed()->latest()->get();
            ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'admin.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Admins'),
                'query' => $admins->whereNull('deleted_at')->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-user-cog'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'admin.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Admins'),
                'query' => $admins->whereNull('deleted_at')->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-user-cog'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'admin.trashed',
                'params' => [],
                'label' => __('Total Trashed Admins'),
                'query' => $admins->whereNotNull('deleted_at'),
                'color' => 'tertiary',
                'icon' => 'fa-user-cog'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <?php if(module_enabled('Speaker')): ?>
            <?php
                $speakers = \Modules\Speaker\Entities\Speaker::withTrashed()->latest()->get();
            ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'speaker.index',
                'params' => ['status' => 'active'],
                'label' => __('Total Active Speakers'),
                'query' => $speakers->whereNull('deleted_at')->where('is_active', true),
                'color' => 'success',
                'icon' => 'fa-user-graduate'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'speaker.index',
                'params' => ['status' => 'inactive'],
                'label' => __('Total Inactive Speakers'),
                'query' => $speakers->whereNull('deleted_at')->where('is_active', false),
                'color' => 'danger',
                'icon' => 'fa-user-graduate'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('admin.components.panel', [
                'route' => 'speaker.trashed',
                'params' => [],
                'label' => __('Total Trashed Speakers'),
                'query' => $speakers->whereNotNull('deleted_at'),
                'color' => 'tertiary',
                'icon' => 'fa-user-graduate'
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <?php echo $__env->renderWhen(module_enabled('Participant'), 'admin.components.panel', [
            'route' => 'participant.index',
            'params' => [],
            'label' => __('Total Participants'),
            'query' => \Modules\Participant\Entities\Participant::latest(),
            'color' => 'primary',
            'icon' => 'fa-user-group'
        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid"></div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Dashboard'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/index.blade.php ENDPATH**/ ?>