<?php $__env->startComponent('mail::message'); ?>
# Hello <?php echo e($participant->name); ?>,

Thank you for expressing interest in <strong><?php echo e($event->title); ?></strong>.<br>
Your registration is successful, and we are thrilled to have you on board!<br>
Your details registered as per below:

<?php $__env->startComponent('mail::table'); ?>
| Details |  |
| --- | --- |
| Name: | <?php echo e($participant->name); ?> |
| Designation: | <?php echo e($participant->designation); ?> |
| Company Name: | <?php echo e($participant->company); ?> |
| Email Address: | <?php echo e($participant->email); ?> |
| Phone No.: | <?php echo e($participant->contact_no); ?> |
<?php echo $__env->renderComponent(); ?>

While we prepare to share more exciting updates with you, here is a summary of the information we currently have about the event:<br>

<?php $__env->startComponent('mail::table'); ?>
| Event |  |
| --- | --- |
| Title: | <?php echo e($event->title); ?> |
| Location: | <?php echo e($event->location); ?> |
| Start Date: | <?php echo e($event->start_date?->format('d/m/Y')); ?> |
| End Date: | <?php echo e($event->end_date?->format('d/m/Y') ?: '-'); ?> |
<?php echo $__env->renderComponent(); ?>

<?php if($event->banner): ?>
<img src="<?php echo e($event->banner_path); ?>" class="banner" alt="<?php echo e($event->title); ?> Banner">
<?php endif; ?>

<?php if(!empty($link)): ?>
<?php $__env->startComponent('mail::button', ['url' => $link]); ?>
<?php echo e($action); ?>

<?php echo $__env->renderComponent(); ?>

<?php $__env->slot('subcopy'); ?>
<?php echo app('translator')->get(
    "If you’re having trouble clicking the \":actionText\" button, copy and paste the URL below\n".
    'into your web browser:',
    [
        'actionText' => $action,
    ]
); ?> <span class="break-all">[<?php echo e($link); ?>](<?php echo e($link); ?>)</span>
<?php $__env->endSlot(); ?>
<?php endif; ?>

Please keep an eye on your inbox for updates, and feel free to reach out to us if you have any questions in the meantime.
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Participant/Resources/views/emails/new-registered-participant.blade.php ENDPATH**/ ?>