<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-name"><?php echo e(__('Name')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('name') ? 'has-danger' : ''); ?>">
        <input type="text" name="name" id="input-name" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" maxlength="100" placeholder="<?php echo e(__('Name')); ?>" value="<?php echo e(old('name', $speaker->name)); ?>" required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'name'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-designation"><?php echo e(__('Designation')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('designation') ? 'has-danger' : ''); ?>">
        <input type="text" name="designation" id="input-designation" class="form-control <?php echo e($errors->has('designation') ? 'is-invalid' : ''); ?>" maxlength="100" placeholder="<?php echo e(__('Designation')); ?>" value="<?php echo e(old('designation', $speaker->designation)); ?>" required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'designation'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>







<?php echo $__env->make('admin.components.fileinput', [
    'thumbnail' => [
        'delete' => asset_exists($speaker->picture),
        'label' => 'avatar',
        'url' => $speaker->avatar_path,
        'path' => $speaker->picture,
        'policy' => 'update',
        'entity' => $speaker::class,
        'hash' => $speaker->hash_id,
    ],
    'label' => 'Profile Picture',
    'name' => 'photo',
    'recommend' => '150px * 150px',
    'required' => !$speaker->exists,
    'uploaded' => $speaker->exists ? ['url' => $speaker->avatar_path, 'path' => $speaker->picture] : [],
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>



<div class="col-12 form-group">
    <label class="form-control-label" for="input-description"><?php echo e(__('Profile Description')); ?> <sup class="text-danger">*</sup> <small class="muted">(<?php echo e(__('Max 300 Characters')); ?>)</small></label>
    <div class="<?php echo e($errors->has('description') ? 'has-danger' : ''); ?>">
        <textarea name="description" id="input-description" class="form-control <?php echo e($errors->has('description') ? 'is-invalid' : ''); ?>" maxlength="300" cols="30" rows="5" required><?php echo e(old('description', $speaker->description)); ?></textarea>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'description'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>



<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3"><?php echo e(__('Status Active')); ?></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $speaker->is_active) ? 'checked' : ''); ?>>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<?php $__env->startPush('vendor-css'); ?>
    <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/select2/dist/css/select2.min.css')); ?>" nonce="<?php echo e(csp_nonce('style')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('vendor-js'); ?>
    <script src="<?php echo e(basset_url('argon/vendor/select2/dist/js/select2.full.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->first(['admin.components.toggle-password'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Speaker/Resources/views/admin/form.blade.php ENDPATH**/ ?>