<?php $__env->startSection('header'); ?>
    <div class="row justify-content-center">
        <div class="col-8 col-sm-6 col-md-4 col-xl-3 mb-5">
            <a href="<?php echo e(route('index')); ?>" title="Home">
                <img src="<?php echo e(uno()->logo); ?>" alt="" class="img-center img-fluid">
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container mt--8 pb-5">
        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-7">
                <div class="card bg-secondary shadow border-0">
                    <div class="card-header bg-transparent py-4">
                        <h1 class="text-uppercase text-center mb-0"><?php echo e(__('Dashboard Log In')); ?></h1>
                    </div>
                    <div class="card-body px-lg-5 py-lg-5">
                        <form role="form" method="POST" action="<?php echo e(route('login')); ?>" id="reCaptchaForm">
                            <?php echo csrf_field(); ?>
                            <?php echo view('honeypot::honeypotFormFields'); ?>

                            <?php echo $__env->make('alerts.success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make('alerts.errors', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                            <div class="form-group mb-3">
                                <div class="input-group input-group-alternative <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> has-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                    </div>
                                    <input class="form-control" placeholder="<?php echo e(__('Email')); ?>" type="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group input-group-alternative toggle-password <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> has-danger <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-unlock-alt"></i></span>
                                    </div>
                                    <input class="form-control" name="password" placeholder="<?php echo e(__('Password')); ?>" type="password" required>
                                </div>
                            </div>
                            <div class="custom-control custom-control-alternative custom-checkbox">
                                <input class="custom-control-input" name="remember" id="rememberMeAdmin" type="checkbox" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <label class="custom-control-label" for="rememberMeAdmin">
                                    <span class="text-muted"><?php echo e(__('Remember Me')); ?></span>
                                </label>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="g-recaptcha btn btn-primary my-4"
                                    data-sitekey="<?php echo e(config('recaptcha.api_site_key')); ?>"
                                    data-callback="onSubmitCaptcha"
                                    data-action="submit"><?php echo e(__('Log In')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12 text-center">
                        <?php if(Route::has('password.request')): ?>
                            <a href="<?php echo e(route('password.request')); ?>">
                                <small><?php echo e(__('Forgot Password?')); ?></small>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <script src="https://www.recaptcha.net/recaptcha/api.js?render=<?php echo e(config('recaptcha.api_site_key')); ?>" async defer nonce="<?php echo e(csp_nonce('script')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->first(['admin.components.toggle-password'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


<?php echo $__env->make('admin.layouts.base', ['class' => 'bg-secondary', 'nav' => false, 'footer' => false], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/auth/login.blade.php ENDPATH**/ ?>