<?php $participant = app(Modules\Participant\Entities\Participant::class); ?>

<?php
    $route_active = route_active('participant.*') ? 'active' : '';
?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $participant)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e($route_active); ?>" href="#navbarParticipants" data-toggle="collapse" role="button" aria-expanded="<?php echo e($route_active ? 'true' : 'false'); ?>" aria-controls="navbarParticipants">
            <i class="fas fa-user-group text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Participants')); ?></span>
        </a>
        <div class="collapse <?php echo e(!$route_active ?: 'show'); ?>" id="navbarParticipants">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('participant.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('participant.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $participant)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('participant.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('participant.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Create New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $participant)): ?>
                    <?php if(route_is_equal('participant.edit') && ($entity = request()->route()->participant)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('participant.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => $entity?->id])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $participant)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('participant.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('participant.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/participants.blade.php ENDPATH**/ ?>