<div class="card">
    <?php $__env->startComponent('admin.components.filter'); ?>
        <?php $__env->slot('status', null); ?>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterType"><?php echo e(__('Filter Type')); ?></label>
                <select class="form-control" name="type" id="filterType" data-toggle="select">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <?php $__currentLoopData = ['image' => __('Photo'), 'video' => __('Video')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if(request()->query('type') == $key): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
    <?php echo $__env->renderComponent(); ?>

    <div class="py-4">
        <table id="tableEventGallery" class="table align-items-center table-flush" width="100%">
            <thead class="thead-light">
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('Actions')); ?></th>
                    <th><?php echo e(__('Thumbnail')); ?></th>
                    <th><?php echo e(__('File')); ?></th>
                    <th><?php echo e(__('Type')); ?></th>
                    <th><?php echo e(__('Size')); ?></th>
                    <th><?php echo e(__('Created At')); ?></th>
                    <th><?php echo e(__('Updated At')); ?></th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<?php echo $__env->make('admin.datatables.table', [
    'name' => 'EventGallery',
    'route' => route('event.gallery.index', $event),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false),
        get_dt_column_config('thumbnail', orderable: false, searchable: false),
        get_dt_column_config('file', 'name'),
        get_dt_column_config('type', 'mime', searchable: false),
        get_dt_column_config('size', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        $("#filterType").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('type', $(this).val());
            } else {
                urlParams.delete('type');
            }

            window.location.search = urlParams;
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Event/Resources/views/admin/gallery/table.blade.php ENDPATH**/ ?>