<?php $event = app(Modules\Event\Entities\Event::class); ?>



<?php $__env->startSection('header'); ?>
    <?php $__env->startComponent('admin.layouts.headers.breadcrumbs'); ?>
        <?php $__env->slot('title'); ?>
            <i class="fas fa-calendar-day fa-lg"></i>
        <?php $__env->endSlot(); ?>

        <li class="breadcrumb-item"><a href="<?php echo e(route('event.index')); ?>"><?php echo e(__('Events')); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('List All')); ?></li>

        <?php $__env->slot('buttons'); ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $event)): ?>
                <a href="<?php echo e(route('event.create')); ?>" class="btn btn-sm btn-neutral"><?php echo e(__('Create New')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('export', $event)): ?>
                <a href="<?php echo e(route('event.export', request()->query())); ?>" class="btn btn-sm btn-primary"><?php echo e(__('Export Excel')); ?></a>
            <?php endif; ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="position-relative container-fluid mt--8">
    <div class="card">
        <?php $__env->startComponent('admin.components.filter'); ?>
            <?php $__env->slot('status', true); ?>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterFeatured"><?php echo e(__('Filter Featured')); ?></label>
                <select class="form-control" name="featured" id="filterFeatured" data-toggle="select">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <?php $__currentLoopData = ['yes', 'no']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($label); ?>" <?php if(request()->query('featured') == $label): echo 'selected'; endif; ?>><?php echo e(ucwords($label)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterFeedback"><?php echo e(__('Filter Submit Feedback')); ?></label>
                <select class="form-control" name="feedback" id="filterFeedback" data-toggle="select">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <?php $__currentLoopData = ['enabled', 'disabled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($label); ?>" <?php if(request()->query('feedback') == $label): echo 'selected'; endif; ?>><?php echo e(ucwords($label)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterSpeaker"><?php echo e(__('Filter Speaker')); ?></label>
                <select class="form-control" name="speaker" id="filterSpeaker" data-toggle="select">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <?php $__currentLoopData = $speakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php if(request()->query('speaker') == $id): echo 'selected'; endif; ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        <?php echo $__env->renderComponent(); ?>

        <div class="py-4">
            <table id="tableEvent" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['update', 'delete'], $event)): ?>
                            <th><?php echo e(__('Actions')); ?></th>
                        <?php endif; ?>
                        <th><?php echo e(__('Banner')); ?></th>
                        <th><?php echo e(__('Title')); ?></th>
                        <th><?php echo e(__('Location')); ?></th>
                        <th><?php echo e(__('Gallery')); ?></th>
                        <th><?php echo e(__('Speakers')); ?></th>
                        <th><?php echo e(__('Participants')); ?></th>
                        <th><?php echo e(__('Feedbacks')); ?></th>
                        <th><?php echo e(__('Start Date')); ?></th>
                        <th><?php echo e(__('End Date')); ?></th>
                        <th><?php echo e(__('Schedule PDF')); ?></th>
                        <th><?php echo e(__('Description')); ?></th>
                        <th><?php echo e(__('Featured')); ?></th>
                        <th><?php echo e(__('Feedback')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Created At')); ?></th>
                        <th><?php echo e(__('Updated At')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.datatables.table', [
    'name' => 'Event',
    'route' => route('event.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $event, can: ['update', 'delete']),
        get_dt_column_config('banner', orderable: false, searchable: false),
        get_dt_column_config('title'),
        get_dt_column_config('location'),
        get_dt_column_config('photos_count', searchable: false),
        get_dt_column_config('speakers_count', searchable: false),
        get_dt_column_config('participants_count', searchable: false),
        get_dt_column_config('feedbacks_count', searchable: false),
        get_dt_column_config('start_date'),
        get_dt_column_config('end_date'),
        get_dt_column_config('file', orderable: false, searchable: false),
        get_dt_column_config('description'),
        get_dt_column_config('feature', 'is_featured', searchable: false),
        get_dt_column_config('feedback', 'enable_submit_feedback', searchable: false),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        $("#filterFeatured").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('featured', $(this).val());
            } else {
                urlParams.delete('featured');
            }

            window.location.search = urlParams;
        });

        $("#filterFeedback").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('feedback', $(this).val());
            } else {
                urlParams.delete('feedback');
            }

            window.location.search = urlParams;
        });

        $("#filterSpeaker").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('speaker', $(this).val());
            } else {
                urlParams.delete('speaker');
            }

            window.location.search = urlParams;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Events Management'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Event/Resources/views/admin/index.blade.php ENDPATH**/ ?>