<div class="card-header pb-3">
    <div id="filterDropdown" class="dropdown">
        <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false" data-offset="0,10">
            <i class="fas fa-filter"></i>
            <span class="mr-2"><?php echo e(__('Filter')); ?></span>
        </button>
        <div class="dropdown-menu pt-1" style="min-width: 300px;">
            <?php if($range ?? true): ?>
                <div class="px-3 py-2">
                    <label class="form-control-label" for="filterDateRange"><?php echo e(__('Filter Date Range by Created At')); ?></label>
                    <div class="input-group flatpickr-date">
                        <input type="date" name="range" id="filterDateRange" class="form-control" placeholder="<?php echo e(__('Date Range')); ?>" data-input>
                        <div class="input-group-append">
                            <button class="btn btn-outline-danger" type="button" data-clear>
                                <i class="fas fa-xmark fa-lg"></i>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(isset($status)): ?>
                <div class="px-3 py-2">
                    <label class="form-control-label" for="filterStatus"><?php echo e(__('Filter Status')); ?></label>
                    <select class="form-control" name="status" id="filterStatus" data-toggle="select">
                        <option value="all"><?php echo e(__('All')); ?></option>
                        <?php $__currentLoopData = (is_array($status) ? $status : ['active', 'inactive']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($label); ?>" <?php if(request()->query('status') == $label): echo 'selected'; endif; ?>><?php echo e(ucwords($label)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            <?php endif; ?>

            <?php echo e($slot); ?>


            <div class="px-3 pt-3 pb-2 d-flex">
                <button id="filterReset" type="button" class="col btn btn-danger"><?php echo e(__('Reset Filter')); ?></button>
                <button id="filterClose" type="button" class="col btn btn-dark"><?php echo e(__('Close Filter')); ?></button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('vendor-css'); ?>
    <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/flatpickr/flatpickr.min.css')); ?>" nonce="<?php echo e(csp_nonce('style')); ?>">
    <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/select2/dist/css/select2.min.css')); ?>" nonce="<?php echo e(csp_nonce('style')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('vendor-js'); ?>
    <script src="<?php echo e(basset_url('argon/vendor/flatpickr/flatpickr.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    <script src="<?php echo e(basset_url('argon/vendor/select2/dist/js/select2.full.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        let filterClosable = true;

        $('#filterDropdown').on({
            "shown.bs.dropdown": function() { filterClosable = false; },
            "hide.bs.dropdown": function() { return filterClosable; },
        });

        <?php if($range ?? true): ?>
            const flatpikr = $(".flatpickr-date").flatpickr({
                wrap: true,
                mode: "range",
                <?php if(request()->query('range')): ?>
                    defaultDate: <?php echo json_encode(explode(' to ', request()->query('range'))); ?>,
                <?php endif; ?>
            });

            flatpikr.config.onClose.push(function(selectedDates, dateStr, instance) {
                if (dateStr) {
                    const urlParams = new URLSearchParams(window.location.search);
                    urlParams.set('range', dateStr);
                    window.location.search = urlParams;
                }
            });

            flatpikr.config.onChange.push(function(selectedDates, dateStr, instance) {
                if (!dateStr) {
                    const urlParams = new URLSearchParams(window.location.search);
                    urlParams.delete('range');
                    window.location.search = urlParams;
                }
            });
        <?php endif; ?>

        <?php if(isset($status)): ?>
            $("#filterStatus").on('change', function (ev) {
                const urlParams = new URLSearchParams(window.location.search);

                if ($(this).val() != 'all') {
                    urlParams.set('status', $(this).val());
                } else {
                    urlParams.delete('status');
                }

                window.location.search = urlParams;
            });
        <?php endif; ?>

        $("#filterReset").on('click', function (ev) {
            window.history.replaceState(null, null, window.location.pathname);
            window.location.reload();
        });

        $("#filterClose").on('click', function (ev) {
            filterClosable = true;
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/components/filter.blade.php ENDPATH**/ ?>