<?php $feedback = app(Modules\Feedback\Entities\Feedback::class); ?>

<?php
    $route_active = route_active('feedback.*') ? 'active' : '';
?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $feedback)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e($route_active); ?>" href="#navbarFeedbacks" data-toggle="collapse" role="button" aria-expanded="<?php echo e($route_active ? 'true' : 'false'); ?>" aria-controls="navbarFeedbacks">
            <i class="fas fa-comments text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Feedbacks')); ?></span>
        </a>
        <div class="collapse <?php echo e(!$route_active ?: 'show'); ?>" id="navbarFeedbacks">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('feedback.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('feedback.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $feedback)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('feedback.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('feedback.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Create New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $feedback)): ?>
                    <?php if(route_is_equal('feedback.edit') && ($entity = request()->route()->feedback)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('feedback.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => $entity?->id])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $feedback)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('feedback.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('feedback.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/feedbacks.blade.php ENDPATH**/ ?>