<?php $participant = app(Modules\Participant\Entities\Participant::class); ?>
<?php $feedback = app(Modules\Feedback\Entities\Feedback::class); ?>



<?php $__env->startSection('header'); ?>
    <?php $__env->startComponent('admin.layouts.headers.breadcrumbs'); ?>
        <?php $__env->slot('title'); ?>
            <i class="fas fa-calendar-day fa-lg"></i>
        <?php $__env->endSlot(); ?>

        <li class="breadcrumb-item"><a href="<?php echo e(route('event.index')); ?>"><?php echo e(__('Events')); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Edit')); ?></li>

        <?php $__env->slot('buttons'); ?>
            <a href="<?php echo e(route('event.schedule.index', $event)); ?>" class="btn btn-sm btn-tertiary text-dark">
                <i class="fas fa-clock mr-2"></i>
                <?php echo e(__('Schedule: :count', ['count' => $event->schedules()->count()])); ?>

            </a>

            <a href="<?php echo e(route('event.gallery.index', $event)); ?>" class="btn btn-sm btn-tertiary text-dark">
                <i class="fas fa-photo-film mr-2"></i>
                <?php echo e(__('Gallery: :count', ['count' => $event->photos()->count()])); ?>

            </a>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $participant)): ?>
                <a href="<?php echo e(route('participant.index', ['event' => $event->id])); ?>" class="btn btn-sm btn-tertiary text-dark">
                    <i class="fas fa-user-group mr-2"></i>
                    <?php echo e(__('Participants: :count', ['count' => $event->participants()->count()])); ?>

                </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $feedback)): ?>
                <a href="<?php echo e(route('feedback.index', ['event' => $event->id])); ?>" class="btn btn-sm btn-tertiary text-dark">
                    <i class="fas fa-comments mr-2"></i>
                    <?php echo e(__('Feedbacks: :count', ['count' => $event->feedbacks()->count()])); ?>

                </a>
            <?php endif; ?>

            <a href="<?php echo e(route('event.index')); ?>" class="btn btn-sm btn-neutral"><?php echo e(__('List All')); ?></a>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                <?php $__env->startComponent('admin.components.form'); ?>
                    <?php $__env->slot('edit', true); ?>
                    <?php $__env->slot('title', __('Edit Event') . ' #' . $event->id); ?>
                    <?php $__env->slot('route', route('event.update', $event->hash_id)); ?>

                    <?php echo $__env->make('event::admin.form', ['event' => $event, 'edit' => true], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('vendor-js'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Edit Event'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Event/Resources/views/admin/edit.blade.php ENDPATH**/ ?>