<?php $banner = app(App\Model\Banner::class); ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $banner)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e(route_active('banner.*')); ?>" href="#navbarBanner" data-toggle="collapse" role="button" aria-expanded="<?php echo e(route_active('banner.*') ? 'true' : 'false'); ?>" aria-controls="navbarBanner">
            <i class="fas fa-images text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Banners')); ?></span>
        </a>
        <div class="collapse <?php echo e(!route_active('banner.*') ?: 'show'); ?>" id="navbarBanner">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('banner.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('banner.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $banner)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('banner.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('banner.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Add New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $banner)): ?>
                    <?php if(route_is_equal('banner.edit') && ($entity = request()->route()->banner)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('banner.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => $entity?->id])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $banner)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('banner.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('banner.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/banners.blade.php ENDPATH**/ ?>