<?php $announcement = app(Modules\Announcement\Entities\Announcement::class); ?>

<?php
    $route_active = route_active('announcement.*') ? 'active' : '';
?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $announcement)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e($route_active); ?>" href="#navbarAnnouncements" data-toggle="collapse" role="button" aria-expanded="<?php echo e($route_active ? 'true' : 'false'); ?>" aria-controls="navbarAnnouncements">
            <i class="fas fa-bullhorn text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Announcements')); ?></span>
        </a>
        <div class="collapse <?php echo e(!$route_active ?: 'show'); ?>" id="navbarAnnouncements">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('announcement.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('announcement.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $announcement)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('announcement.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('announcement.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Create New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $announcement)): ?>
                    <?php if(route_is_equal('announcement.edit') && ($entity = request()->route()->announcement)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('announcement.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => $entity?->id])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $announcement)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('announcement.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('announcement.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/announcements.blade.php ENDPATH**/ ?>