<?php $__env->startComponent('admin.components.card'); ?>
    <?php $__env->slot('title', __('Mail SMTP')); ?>
    <?php $__env->slot('class', 'pb-0'); ?>

    <div class="row">
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-from-name"><?php echo e(__('Sender Name')); ?> <sup class="text-danger">*</sup></label>
            <div class="<?php echo e($errors->has('mail-from-name') ? 'has-danger' : ''); ?>">
                <input type="text" name="mail-from-name" id="mail-from-name" class="form-control <?php echo e($errors->has('mail-from-name') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Sender Name')); ?>" value="<?php echo e(old('mail-from-name', config('mail.from.name'))); ?>" required>
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'mail-from-name'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-from-address"><?php echo e(__('Sender Email')); ?> <sup class="text-danger">*</sup></label>
            <div class="<?php echo e($errors->has('mail-from-address') ? 'has-danger' : ''); ?>">
                <input type="email" name="mail-from-address" id="mail-from-address" class="form-control <?php echo e($errors->has('mail-from-address') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Sender Email')); ?>" value="<?php echo e(old('mail-from-address', config('mail.from.address'))); ?>" required>
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'mail-from-address'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-12 form-group">
            <hr class="my-0">
        </div>
        <div class="col-12 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-host"><?php echo e(__('Host')); ?> <sup class="text-danger">*</sup></label>
            <div class="<?php echo e($errors->has('mail-mailers-smtp-host') ? 'has-danger' : ''); ?>">
                <input type="text" name="mail-mailers-smtp-host" id="mail-mailers-smtp-host" class="form-control <?php echo e($errors->has('mail-mailers-smtp-host') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Host')); ?>" value="<?php echo e(old('mail-mailers-smtp-host', config('mail.mailers.smtp.host'))); ?>" required>
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'mail-mailers-smtp-host'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-port"><?php echo e(__('Port')); ?> <sup class="text-danger">*</sup></label>
            <div class="<?php echo e($errors->has('mail-mailers-smtp-port') ? 'has-danger' : ''); ?>">
                <input type="tel" inputmode="numeric" name="mail-mailers-smtp-port" id="mail-mailers-smtp-port" class="form-control <?php echo e($errors->has('mail-mailers-smtp-port') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Port')); ?>" value="<?php echo e(old('mail-mailers-smtp-port', config('mail.mailers.smtp.port'))); ?>" required>
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'mail-mailers-smtp-port'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-encryption"><?php echo e(__('Encryption')); ?> <sup class="text-danger">*</sup></label>
            <div class="<?php echo e($errors->has('mail-mailers-smtp-encryption') ? 'has-danger' : ''); ?>">
                <input type="text" name="mail-mailers-smtp-encryption" id="mail-mailers-smtp-encryption" class="form-control <?php echo e($errors->has('mail-mailers-smtp-encryption') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Encryption')); ?>" value="<?php echo e(old('mail-mailers-smtp-encryption', config('mail.mailers.smtp.encryption'))); ?>" required>
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'mail-mailers-smtp-encryption'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-username"><?php echo e(__('Username')); ?></label>
            <span class="form-text text-muted mt-0"><?php echo e(config('mail.mailers.smtp.username') ? mask(config('mail.mailers.smtp.username')) : 'N/A'); ?></span>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-password"><?php echo e(__('Password')); ?></label>
            <span class="form-text text-muted mt-0"><?php echo e(config('mail.mailers.smtp.password') ? mask(config('mail.mailers.smtp.password')) : 'N/A'); ?></span>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-username"><?php echo e(__('New Username')); ?></label>
            <div class="<?php echo e($errors->has('mail-mailers-smtp-username') ? 'has-danger' : ''); ?>">
                <input type="text" name="mail-mailers-smtp-username" id="mail-mailers-smtp-username" class="form-control <?php echo e($errors->has('mail-mailers-smtp-username') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Username')); ?>" value="<?php echo e(old('mail-mailers-smtp-username')); ?>">
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'mail-mailers-smtp-username'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-password"><?php echo e(__('New Password')); ?></label>
            <div class="<?php echo e($errors->has('mail-mailers-smtp-password') ? 'has-danger' : ''); ?>">
                <input type="text" name="mail-mailers-smtp-password" id="mail-mailers-smtp-password" class="form-control <?php echo e($errors->has('mail-mailers-smtp-password') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Password')); ?>" value="<?php echo e(old('mail-mailers-smtp-password')); ?>" autocomplete="off">
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'mail-mailers-smtp-password'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-12 form-group">
            <div class="text-center">
                <button id="testSMTP" type="button" class="btn btn-info" data-action="<?php echo e(route('setting.smtp')); ?>"><i class="fas fa-paper-plane mr-2"></i><?php echo e(__('Test SMTP')); ?></button>
            </div>
        </div>
    </div>
<?php echo $__env->renderComponent(); ?>

<?php $__env->startPush('js'); ?>
    <?php $bassetBlock = 'admin/js/setting-test-smtp.js'; ob_start(); ?>
        <script nonce="<?php echo e(basset_nonce('script')); ?>">
            $('#testSMTP').on('click', function() {
                var btn = $(this);
                var action = btn.data('action');
                var data = {};

                data.name = $('#mail-from-name').val();
                data.email = $('#mail-from-address').val();
                data.host = $('#mail-mailers-smtp-host').val();
                data.port = $('#mail-mailers-smtp-port').val();
                data.encryption = $('#mail-mailers-smtp-encryption').val();
                data.username = $('#mail-mailers-smtp-username').val();
                data.password = $('#mail-mailers-smtp-password').val();
                data.save = true;

                btn.prop('disabled', true);

                $.ajax({
                    url: action,
                    method: 'post',
                    data: data,
                    success: function (res) {
                        alert(res.message);
                        btn.prop('disabled', false);
                    },
                    error: function () {
                        alert(res.message);
                        btn.prop('disabled', false);
                    },
                    complete: function () {
                        btn.prop('disabled', false);
                    }
                });
            });
        </script>
    <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/setting/module/smtp.blade.php ENDPATH**/ ?>