<?php $audit_login_entity = app(App\Model\AuditLogin::class); ?>
<?php $setting_entity = app(App\Model\Setting::class); ?>

<nav class="sidenav navbar navbar-vertical fixed-left navbar-expand-xs navbar-light bg-white" id="sidenav-main">
    <div class="scrollbar-inner scroll-scrollx_visible">
        <div class="sidenav-header d-flex align-items-center">
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(uno()->logo); ?>" class="navbar-brand-img" alt="logo">
            </a>
            <div class="ml-auto">
                <div class="sidenav-toggler d-none d-xl-block" data-action="sidenav-unpin" data-target="#sidenav-main">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="navbar-inner">
            <div class="collapse navbar-collapse" id="sidenav-collapse-main">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(route_active('home')); ?>" href="<?php echo e(route('home')); ?>">
                            <i class="fas fa-home text-primary"></i>
                            <span class="nav-link-text"><?php echo e(__('Dashboard')); ?></span>
                        </a>
                    </li>
                </ul>
                <hr class="my-3">
                <h6 class="navbar-heading p-0 text-muted"><?php echo e(__('Modules')); ?></h6>
                <ul class="navbar-nav mb-md-3">
                    
                    <?php echo $__env->renderWhen(module_enabled('Event'), 'admin.layouts.navbars.sidebar.events', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                    <?php echo $__env->renderWhen(module_enabled('Feedback'), 'admin.layouts.navbars.sidebar.feedbacks', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                    <?php echo $__env->renderWhen(module_enabled('Announcement'), 'admin.layouts.navbars.sidebar.announcements', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                </ul>
                <hr class="my-3">
                <h6 class="navbar-heading p-0 text-muted"><?php echo e(__('Users')); ?></h6>
                <ul class="navbar-nav mb-md-3">
                    <?php echo $__env->renderWhen(module_enabled('Admin'), 'admin.layouts.navbars.sidebar.admins', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                    <?php echo $__env->renderWhen(module_enabled('User'), 'admin.layouts.navbars.sidebar.users', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                    <?php echo $__env->renderWhen(module_enabled('Speaker'), 'admin.layouts.navbars.sidebar.speakers', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                    <?php echo $__env->renderWhen(module_enabled('Participant'), 'admin.layouts.navbars.sidebar.participants', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                </ul>
                <hr class="my-3">
                <h6 class="navbar-heading p-0 text-muted"><?php echo e(__('System')); ?></h6>
                <ul class="navbar-nav mb-md-3">
                    
                    <?php echo $__env->make('admin.layouts.navbars.sidebar.banners', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php echo $__env->make('admin.layouts.navbars.sidebar.staticpages', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $audit_login_entity)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('audit-login.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('audit-login.index')); ?>">
                                <i class="fas fa-user-lock text-primary"></i>
                                <span class="nav-link-text"><?php echo e(__('Audit Logins')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $setting_entity)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('setting.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('setting.index')); ?>">
                                <i class="fas fa-tools text-primary"></i>
                                <span class="nav-link-text"><?php echo e(__('Settings')); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link">
                            <i class="fas fa-tag"></i>
                            <span class="nav-link-text"><?php echo e(config('app.version')); ?></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar.blade.php ENDPATH**/ ?>