<div class="col-12">
    <div class="row">
        <?php if(count($thumbnail ??= [])): ?>
            <div class="position-relative <?php echo e($thumbnail['class'] ?? 'col-sm-5 col-md-4 col-lg-3 col-xl-2 mb-4 form-group'); ?>">
                <?php if($thumbnail['delete'] ?? false): ?>
                    <button type="button" class="btn btn-danger btn-sm btn-delete-image position-absolute m-2"
                        data-name="<?php echo e($name); ?>"
                        data-label="<?php echo e($thumbnail['label']); ?>"
                        data-path="<?php echo e($thumbnail['path']); ?>"
                        data-policy="<?php echo e($thumbnail['policy']); ?>"
                        data-entity="<?php echo e($thumbnail['entity']); ?>"
                        data-column="<?php echo e($thumbnail['column'] ?? ''); ?>"
                        data-hash="<?php echo e($thumbnail['hash'] ?? ''); ?>"
                        data-disk="<?php echo e($thumbnail['disk'] ?? ''); ?>"
                        data-placement="right" data-toggle="tooltip" data-original-title="Delete" title="Delete"
                    >
                        <i class="fas fa-trash-alt"></i>
                    </button>
                <?php endif; ?>
                <?php if($thumbnail['show'] ?? false): ?>
                    <a role="button" href="<?php echo e($thumbnail['show']); ?>" class="btn btn-primary btn-sm position-absolute m-2" target="_blank"
                        data-placement="right" data-toggle="tooltip" data-original-title="Show" title="Show"
                    >
                        <i class="fas fa-eye"></i>
                    </a>
                <?php endif; ?>
                <img src="<?php echo e($thumbnail['url']); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses(['img-thumbnail w-100', 'p-4' => $thumbnail['padding'] ?? false]); ?>" class="" alt="<?php echo e(ucwords($thumbnail['label'] ?? 'thumbnail')); ?>">
            </div>
        <?php endif; ?>
        <div class="col">
            <div class="form-group">
                <label class="form-control-label" for="<?php echo e($name); ?>">
                    <?php echo e($label); ?>

                    <?php if($required ?? false): ?>
                    <sup class="text-danger">*</sup>
                    <?php endif; ?>
                </label>
                <small class="form-text text-muted mt-0">
                    <?php echo __('Only <strong>:mimes</strong> extension allowed with maximum of <strong>:maxsize</strong> in file size', ['mimes' => $mimes ?? 'PNG, JPEG, JPG', 'maxsize' => in_filesize($maxsize ?? config('app.max_file_size'))]); ?>

                </small>
                <?php if($recommend ?? false): ?>
                    <small class="form-text text-muted mt-1">
                        <?php echo __('Recommended size: <strong>:size</strong>', ['size' => $recommend]); ?>

                    </small>
                <?php endif; ?>
                <div class="input-group mt-3">
                    <?php if($elfinder ?? admin_dashboard()): ?>
                        <div class="input-group-prepend">
                            <button class="btn btn-primary" type="button" id="<?php echo e($name); ?>ElFinderOpen">
                                <i class="fas fa-folder-open"></i>
                            </button>
                        </div>
                    <?php endif; ?>
                    <div class="custom-file <?php echo e($errors->has($name) ? 'has-danger' : ''); ?>">
                        <input type="file" name="<?php echo e($name); ?>" class="file-upload custom-file-input <?php echo e($errors->has($name) ? 'is-invalid' : ''); ?>" id="<?php echo e($name); ?>ElFinderFileInput" accept="<?php echo e(($mimes ?? false) ? '*' : 'image/*'); ?>">
                        <label class="custom-file-label" for="<?php echo e($name); ?>ElFinderFileInput"><?php echo e(__('Select :label', ['label' => $label])); ?></label>
                    </div>
                </div>
                <?php if(count($uploaded ??= [])): ?>
                    <a id="<?php echo e($name); ?>UploadedFilePath" href="<?php echo e($uploaded['url']); ?>" class="d-block mt-2" target="_blank"><?php echo e($uploaded['path']); ?></a>
                <?php endif; ?>
                <?php echo $__env->make('alerts.feedback', ['field' => $name], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        $(document).ready(function() {
            <?php if($elfinder ?? admin_dashboard()): ?>
                $('#<?php echo e($name); ?>ElFinderOpen').on('click', function (e) {
                    window.open("<?php echo e(route('elfinder.tinymce5', ['id' => $name])); ?>", '_blank', 'menubar=no,status=no,toolbar=no,scrollbars=yes,height=500,width=1000');
                });
            <?php endif; ?>

            $('#<?php echo e($name); ?>ElFinderFileInput').on('change', function (e) {
                $(this).parent().find('input[type=hidden]').remove();
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php if (! $__env->hasRenderedOnce('fedac52c-8dbe-4486-a4cb-4655d0d68369')): $__env->markAsRenderedOnce('fedac52c-8dbe-4486-a4cb-4655d0d68369');
$__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        $(document).ready(function() {
            if ($('.btn-delete-image').length) {
                $('.btn-delete-image').on('click', function (e) {
                    const $this = $(this);

                    if (confirm("<?php echo e(__('Are you sure to proceed with this action?')); ?>")) {
                        $this.html('<i class="fas fa-arrows-rotate fa-spin"></i>').prop('disabled', true);

                        const name = $this.data('name');
                        const label = $this.data('label');
                        const path = $this.data('path');
                        const policy = $this.data('policy');
                        const entity = $this.data('entity');
                        const column = $this.data('column');
                        const hash = $this.data('hash');
                        const disk = $this.data('disk');

                        $.ajax({
                            url: "<?php echo e(route('destroy.image')); ?>",
                            method: 'delete',
                            data: {
                                label,
                                path,
                                policy,
                                entity,
                                column,
                                hash,
                                disk,
                            },
                            success: function (response) {
                                alert(response['message']);

                                if (response['status']) {
                                    $this.parent().remove();
                                }

                                if ($(`#${name}UploadedFilePath`).length) {
                                    $(`#${name}UploadedFilePath`).remove();
                                }
                            },
                            error: function (response) {
                                $this.html('<i class="fas fa-trash-alt"></i>').prop('disabled', false);
                                alert("<?php echo e(__('Unable to delete. Please try again.')); ?>");
                            }
                        });
                    }
                });
            }
        });
    </script>
<?php $__env->stopPush(); endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/components/fileinput.blade.php ENDPATH**/ ?>