<?php $speaker = app(Modules\Speaker\Entities\Speaker::class); ?>

<?php
    $route_active = route_active('speaker.*') ? 'active' : '';
?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $speaker)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e($route_active); ?>" href="#navbarSpeakers" data-toggle="collapse" role="button" aria-expanded="<?php echo e($route_active ? 'true' : 'false'); ?>" aria-controls="navbarSpeakers">
            <i class="fas fa-user-graduate text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Speakers')); ?></span>
        </a>
        <div class="collapse <?php echo e(!$route_active ?: 'show'); ?>" id="navbarSpeakers">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('speaker.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('speaker.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $speaker)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('speaker.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('speaker.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Create New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $speaker)): ?>
                    <?php if(route_is_equal('speaker.edit') && ($entity = request()->route()->speaker)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('speaker.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => $entity?->id])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $speaker)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('speaker.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('speaker.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/speakers.blade.php ENDPATH**/ ?>