<?php $admin = app(Modules\Admin\Entities\Admin::class); ?>

<?php
    $route_active = route_active('admin.*') ? 'active' : '';
?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $admin)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e($route_active); ?>" href="#navbarAdmins" data-toggle="collapse" role="button" aria-expanded="<?php echo e($route_active ? 'true' : 'false'); ?>" aria-controls="navbarAdmins">
            <i class="fas fa-user-cog text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Admins')); ?></span>
        </a>
        <div class="collapse <?php echo e(!$route_active ?: 'show'); ?>" id="navbarAdmins">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('admin.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('admin.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $admin)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('admin.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('admin.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Create New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $admin)): ?>
                    <?php if(route_is_equal('admin.edit') && ($entity = request()->route()->admin)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('admin.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => $entity?->id])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $admin)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('admin.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('admin.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/admins.blade.php ENDPATH**/ ?>