<div class="<?php echo e($classes ?? 'col-xl-4 col-sm-6 mb-4'); ?>">
    <a href="<?php echo e(route($route, $params ?? null)); ?>" role="button" class="card card-stats mb-0 h-100 text-decoration-none shadow">
        <div class="card-body d-flex flex-column">
            <div class="row mb-auto">
                <div class="col">
                    <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e($label); ?></h5>
                    <span class="h2 font-weight-bold mb-0"><?php echo e($count ??= $query?->count()); ?></span>
                </div>
                <div class="col-auto">
                    <div class="icon icon-shape bg-<?php echo e($color ?? collect(['success', 'danger', 'warning', 'info', 'primary'])->random()); ?> text-white rounded-circle shadow">
                        <i class="fas <?php echo e($icon); ?> text-white"></i>
                    </div>
                </div>
            </div>
            <p class="mt-3 mb-0 text-muted text-sm text-nowrap">
                <?php if($count && $query?->first()->created_at): ?>
                    <?php echo e(__('Last created since :time', ['time' => $query->first()->created_at->diffForHumans()])); ?>

                <?php else: ?>
                    N/A
                <?php endif; ?>
            </p>
        </div>
    </a>
</div>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/components/panel.blade.php ENDPATH**/ ?>