<div class="col-12 form-group">
    <label class="form-control-label" for="input-name"><?php echo e(__('Name')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('name') ? 'has-danger' : ''); ?>">
        <input type="text" name="name" id="input-name" class="form-control <?php echo e($errors->has('name') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Name')); ?>" value="<?php echo e(old('name', $admin->name)); ?>" autofocus required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'name'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-email"><?php echo e(__('Email')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('name') ? 'has-danger' : ''); ?>">
        <input type="email" name="email" id="input-email" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Email')); ?>" value="<?php echo e(old('email', $admin->email)); ?>" required autocomplete="new-email">
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'email'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-contact_no"><?php echo e(__('Contact No.')); ?></label>
    <div class="<?php echo e($errors->has('contact_no') ? 'has-danger' : ''); ?>">
        <input type="tel" inputmode="numeric" name="contact_no"  id="input-contact_no" class="form-control <?php echo e($errors->has('contact_no') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Contact No.')); ?>" value="<?php echo e(old('contact_no', $admin->contact_no)); ?>">
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'contact_no'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>



<?php echo $__env->make('admin.components.fileinput', [
    'thumbnail' => [
        'delete' => asset_exists($admin->picture),
        'label' => 'avatar',
        'url' => $admin->avatar_path,
        'path' => $admin->picture,
        'policy' => 'update',
        'entity' => $admin::class,
        'hash' => $admin->hash_id,
    ],
    'label' => 'Avatar',
    'name' => 'photo',
    'uploaded' => $admin->exists ? ['url' => $admin->avatar_path, 'path' => $admin->picture] : [],
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


    <div class="col-12 form-group">
        <hr class="mb-0 mt-2">
    </div>

    <div class="col-md-6 form-group">
        <label class="form-control-label" for="input-password">
            <?php echo e(__('Password')); ?> <?php if(empty($edit)): ?> <sup class="text-danger">*</sup> <?php endif; ?>
        </label>
        <div class="<?php echo e($errors->has('password') ? 'has-danger' : ''); ?> toggle-password">
            <input type="password" name="password" id="input-password" class="form-control <?php echo e($errors->has('password') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Password')); ?>" <?php if(empty($edit)): ?> required <?php endif; ?> autocomplete="new-password">
        </div>
        <?php echo $__env->make('alerts.feedback', ['field' => 'password'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    <div class="col-md-6 form-group">
        <label class="form-control-label" for="input-password-confirmation">
            <?php echo e(__('Confirm Password')); ?> <?php if(empty($edit)): ?> <sup class="text-danger">*</sup> <?php endif; ?>
        </label>
        <div class="<?php echo e($errors->has('password') ? 'has-danger' : ''); ?> toggle-password">
            <input type="password" name="password_confirmation" id="input-password-confirmation" class="form-control" placeholder="<?php echo e(__('Confirm Password')); ?>" <?php if(empty($edit)): ?> required <?php endif; ?> autocomplete="new-password">
        </div>
    </div>


<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3"><?php echo e(__('Status Active')); ?> <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $admin->is_active) ? 'checked' : ''); ?>>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<?php if(!$admin?->isSuperAdmin() && (admin()?->id != $admin->id)): ?>
    <div class="col-12 form-group">
        <hr class="mb-0 mt-2">
    </div>

    <div class="col-12 form-group">
        <label class="form-control-label"><?php echo e(__('Module Permissions')); ?></label>
    </div>

    <div class="col-12">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4">
            <?php $__currentLoopData = $admin::getModulesList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col form-group d-flex align-items-center">
                    <label class="form-control-label mb-0 mr-3"><?php echo e(ucwords(str($module)->plural())); ?></label>
                    <label class="custom-toggle ml-auto mr-5">
                        <input type="checkbox" name="permissions[]" value="<?php echo e($module); ?>" <?php if(in_array($module, old('permissions', $admin->permissions ?? []))): echo 'checked'; endif; ?>>
                        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
                    </label>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->first(['admin.components.toggle-password'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Admin/Resources/views/form.blade.php ENDPATH**/ ?>