<?php $__env->startComponent('admin.components.card'); ?>
    <?php $__env->slot('title', __('Maintenance Mode')); ?>
    <?php $__env->slot('class', 'pb-0'); ?>

    <div class="row">
        <div class="col-12 form-group">
            <label class="form-control-label" for="app-maintenance_mode_status"><?php echo e(__('Status')); ?> <sup class="text-danger">*</sup></label>
            <div class="<?php echo e($errors->has('app-maintenance_mode_status') ? 'has-danger' : ''); ?>">
                <select class="form-control <?php echo e($errors->has('app-maintenance_mode_status') ? 'is-invalid' : ''); ?>" name="app-maintenance_mode_status" id="app-maintenance_mode_status" required>
                    <option value="enable" <?php if(app()->isDownForMaintenance()): ?> selected <?php endif; ?>><?php echo e(__('Enable')); ?></option>
                    <option value="disable" <?php if(!app()->isDownForMaintenance()): ?> selected <?php endif; ?>><?php echo e(__('Disable')); ?></option>
                </select>
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'app-maintenance_mode_status'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <div class="col-12 form-group">
            <label class="form-control-label" for="app-maintenance_mode_message"><?php echo e(__('Message')); ?> <sup class="text-danger">*</sup></label>
            <small class="form-text text-muted mt-0 mb-3"><?php echo e(__('Message to be display to the end-user in the maintenance page.')); ?></small>
            <div class="<?php echo e($errors->has('app-maintenance_mode_message') ? 'has-danger' : ''); ?>">
                <textarea name="app-maintenance_mode_message" id="app-maintenance_mode_message" class="form-control <?php echo e($errors->has('app-maintenance_mode_message') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Message')); ?>" rows="5"><?php echo e(old('app-maintenance_mode_message', config('app.maintenance_mode_message'))); ?></textarea>
            </div>
            <?php echo $__env->make('alerts.feedback', ['field' => 'app-maintenance_mode_message'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/setting/module/maintenance.blade.php ENDPATH**/ ?>