<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo e(__('elFinder 2.0')); ?></title>

    <!-- jQuery and jQuery UI (REQUIRED) -->
    <link rel="stylesheet" href="<?php echo e(basset_url('https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/smoothness/jquery-ui.css')); ?>" nonce="<?php echo e(csp_nonce('style')); ?>">

    <script src="<?php echo e(basset_url('https://ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(basset_url('https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js')); ?>"></script>

    <!-- elFinder CSS (REQUIRED) -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(basset_url($dir.'/css/elfinder.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(basset_url($dir.'/css/theme.min.css')); ?>">

    <?php $bassetBlock = 'admin/css/elfinder-custom-style.css'; ob_start(); ?>
        <style type="text/css">
            .elfinder-navdock .ui-resizable-n {
                display: none;
            }

            .elfinder-quicklook-titlebar-icon.elfinder-titlebar-button-right .ui-icon {
                margin-top: 0;
            }

            .elfinder-dialog-title {
                width: 100%;
                text-overflow: ellipsis;
            }

            .elfinder-icon-minimize {
                display: none
            }

            .elfinder-button-menu.elfinder-button-search-menu {
                display: none !important;
            }

            .elfinder-contextmenu-item.ui-state-active {
                background: #2196f3;
            }

            .elfinder-button-search input {
                box-sizing: border-box !important;
                padding: 0 35px !important;
            }

            .elfinder .elfinder-toast > div:before {
                font-size: 35px;
                top: 0;
            }
        </style>
    <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>

    <!-- elFinder JS (REQUIRED) -->
    <script src="<?php echo e(basset_url($dir.'/js/elfinder.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>

    <?php if($locale): ?>
        <!-- elFinder translation (OPTIONAL) -->
        <script src="<?php echo e(basset_url($dir."/js/i18n/elfinder.$locale.js")); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    <?php endif; ?>

    <!-- elFinder initialization (REQUIRED) -->
    <script type="text/javascript" nonce="<?php echo e(csp_nonce('script')); ?>">
        var FileBrowserDialogue = {
            init: function() {
                // Here goes your code for setting your custom things onLoad.
            },
            mySubmit: function (file) {
                window.parent.postMessage({
                    mceAction: 'fileSelected',
                    data: {
                        file: file
                    }
                }, '*');
            }
        };

        $().ready(function() {
            var elf = $('#elfinder').elfinder({
                height: '100%',
                onlyMimes: <?php echo json_encode(explode(',', env('ELFINDER_UPLOAD_ALLOW_MIMES', 'image,video,application/pdf'))); ?>,
                ui: ['toolbar', 'tree', 'path', 'stat'],
                uiOptions: {
                    // toolbar configuration
                    toolbar : [
                        ['home', 'back', 'forward', 'up', 'reload'],
                        // ['netmount'],
                        [
                            'mkdir',
                            // 'mkfile',
                            'upload'
                        ],
                        ['open', 'download', 'getfile'],
                        ['undo', 'redo'],
                        [
                            'copy', 'cut', 'paste', 'rm', 'empty',
                            // 'hide'
                        ],
                        [
                            'duplicate', 'rename',
                            // 'edit', 'resize', 'chmod'
                        ],
                        // ['selectall', 'selectnone', 'selectinvert'],
                        [
                            'quicklook',
                            'info'
                        ],
                        // ['extract', 'archive'],
                        ['search'],
                        ['view', 'sort'],
                        // ['preference', 'help'],
                        // ['fullscreen']
                    ],
                },
                contextmenu: {
                    navbar: ['open', 'opennew', 'download', '|', 'upload', 'mkdir', '|', 'copy', 'cut', 'paste', 'duplicate', '|', 'rm', 'empty', '|', 'rename'],
                    cwd: ['undo', 'redo', '|', 'back', 'up', 'reload', '|', 'upload', 'mkdir', 'paste', '|', 'empty', '|', 'view', 'sort', 'selectall'],
                    files: ['getfile', '|', 'open', 'opennew', 'download', 'opendir', '|', 'upload', 'mkdir', '|', 'copy', 'cut', 'paste', 'duplicate', '|', 'rm', 'empty', '|', 'rename', '|', 'selectall', '|', 'quicklook', 'info']
                },
                commandsOptions: {
                    search: {
                        searchTypes: {}
                    }
                },
                resizable: false,
                // set your elFinder options here
                <?php if($locale): ?>
                    lang: '<?php echo e($locale); ?>', // locale
                <?php endif; ?>
                customData: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                url: '<?php echo e(route("elfinder.connector")); ?>',  // connector URL
                soundPath: '<?php echo e(asset($dir.'/sounds')); ?>',
                getFileCallback: function(file) { // editor callback
                    <?php if(request()->input('id')): ?>
                        window.parent.opener.processELFinderSelectedFile(file.path, '<?php echo e(request()->input('id')); ?>');
                        window.close();
                    <?php else: ?>
                        FileBrowserDialogue.mySubmit(file); // pass selected file path to TinyMCE
                    <?php endif; ?>
                }
            }).elfinder('instance');
        });
    </script>
</head>
<body>

<!-- Element where elFinder will be created (REQUIRED) -->
<div id="elfinder"></div>

</body>
</html>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/vendor/elfinder/tinymce5.blade.php ENDPATH**/ ?>