<?php $speaker = app(Modules\Speaker\Entities\Speaker::class); ?>



<?php $__env->startSection('header'); ?>
    <?php $__env->startComponent('admin.layouts.headers.breadcrumbs'); ?>
        <?php $__env->slot('title'); ?>
            <i class="fas fa-user-graduate fa-lg"></i>
        <?php $__env->endSlot(); ?>

        <li class="breadcrumb-item"><a href="<?php echo e(route('speaker.index')); ?>"><?php echo e(__('Speakers')); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('List All')); ?></li>

        <?php $__env->slot('buttons'); ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $speaker)): ?>
                <a href="<?php echo e(route('speaker.create')); ?>" class="btn btn-sm btn-neutral"><?php echo e(__('Create New')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('export', $speaker)): ?>
                <a href="<?php echo e(route('speaker.export', request()->query())); ?>" class="btn btn-sm btn-primary"><?php echo e(__('Export Excel')); ?></a>
            <?php endif; ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="position-relative container-fluid mt--8">
    <?php if(request()->has('event')): ?>
        <h1 class="text-white mb-3"><?php echo e(__('Event #:id Speakers', ['id' => request()->query('event')])); ?></h1>
    <?php endif; ?>

    <div class="card">
        <?php $__env->startComponent('admin.components.filter'); ?>
            <?php $__env->slot('status', true); ?>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterEvent"><?php echo e(__('Filter Event')); ?></label>
                <select class="form-control" name="event" id="filterEvent" data-toggle="select">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php if(request()->query('event') == $id): echo 'selected'; endif; ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        <?php echo $__env->renderComponent(); ?>

        <div class="py-4">
            <table id="tableSpeaker" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['update', 'delete'], $speaker)): ?>
                            <th><?php echo e(__('Actions')); ?></th>
                        <?php endif; ?>
                        <th><?php echo e(__('Profile')); ?></th>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('Designation')); ?></th>
                        
                        
                        <th><?php echo e(__('Description')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Created At')); ?></th>
                        <th><?php echo e(__('Updated At')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.datatables.table', [
    'name' => 'Speaker',
    'route' => route('speaker.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $speaker, can: ['update', 'delete']),
        get_dt_column_config('avatar', orderable: false, searchable: false),
        get_dt_column_config('name'),
        get_dt_column_config('designation'),
        // get_dt_column_config('email'),
        // get_dt_column_config('contact_no'),
        get_dt_column_config('description'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        $("#filterEvent").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('event', $(this).val());
            } else {
                urlParams.delete('event');
            }

            window.location.search = urlParams;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Speakers Management'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Speaker/Resources/views/admin/index.blade.php ENDPATH**/ ?>