<?php $static_page = app(App\Model\StaticPage::class); ?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $static_page)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e(route_active('static-page.*')); ?>" href="#navbarStaticPage" data-toggle="collapse" role="button" aria-expanded="<?php echo e(route_active('static-page.*') ? 'true' : 'false'); ?>" aria-controls="navbarStaticPage">
            <i class="fas fa-pager text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Pages')); ?></span>
        </a>
        <div class="collapse <?php echo e(!route_active('static-page.*') ?: 'show'); ?>" id="navbarStaticPage">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('static-page.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('static-page.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $static_page)): ?>
                    
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('static-page.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('static-page.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Create New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $static_page)): ?>
                    <?php if(route_is_equal('static-page.edit') && ($entity = request()->route()->static_page)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('static-page.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => $entity?->id])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $static_page)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('static-page.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('static-page.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/staticpages.blade.php ENDPATH**/ ?>