<?php $__env->startSection('header'); ?>
    <div class="row justify-content-center">
        <div class="col-8 col-sm-6 col-md-4 col-xl-3 mb-5">
            <a href="<?php echo e(route('index')); ?>" title="Home">
                <img src="<?php echo e(uno()->logo); ?>" alt="" class="img-center img-fluid">
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container mt--8 pb-5">
        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-7">
                <div class="card bg-secondary shadow border-0">
                    <div class="card-header bg-transparent py-4">
                        <h1 class="text-uppercase text-center mb-0"><?php echo e(__('Reset Password')); ?></h1>
                    </div>
                    <div class="card-body px-lg-5 py-lg-5">
                        <form role="form" method="POST" action="<?php echo e(route('password.email')); ?>" id="reCaptchaForm">
                            <?php echo csrf_field(); ?>
                            <?php echo view('honeypot::honeypotFormFields'); ?>

                            <?php echo $__env->make('alerts.success', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make('alerts.errors', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                            <div class="form-group<?php echo e($errors->has('email') ? ' has-danger' : ''); ?> mb-3">
                                <div class="input-group input-group-alternative">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                    </div>
                                    <input class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" placeholder="<?php echo e(__('Email')); ?>" type="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="g-recaptcha btn btn-primary my-4"
                                    data-sitekey="<?php echo e(config('recaptcha.api_site_key')); ?>"
                                    data-callback="onSubmitCaptcha"
                                    data-action="submit"><?php echo e(__('Send Password Reset Link')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12 text-center">
                        <a href="<?php echo e(route('login')); ?>">
                            <small><?php echo e(__('Back to Log In')); ?></small>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <script src="https://www.recaptcha.net/recaptcha/api.js?render=<?php echo e(config('recaptcha.api_site_key')); ?>" async defer nonce="<?php echo e(csp_nonce('script')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.base', ['class' => 'bg-secondary', 'nav' => false, 'footer' => false], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/auth/passwords/email.blade.php ENDPATH**/ ?>