<?php $event = app(Modules\Event\Entities\Event::class); ?>

<?php
    $route_active = route_active('event.*') ? 'active' : '';
?>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-any', $event)): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo e($route_active); ?>" href="#navbarEvents" data-toggle="collapse" role="button" aria-expanded="<?php echo e($route_active ? 'true' : 'false'); ?>" aria-controls="navbarEvents">
            <i class="fas fa-calendar-day text-primary"></i>
            <span class="nav-link-text"><?php echo e(__('Events')); ?></span>
        </a>
        <div class="collapse <?php echo e(!$route_active ?: 'show'); ?>" id="navbarEvents">
            <ul class="nav nav-sm flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo e(!route_active('event.index') ?: 'active text-primary'); ?>" href="<?php echo e(route('event.index')); ?>">
                        <i class="fas fa-list"></i>
                        <span class="nav-link-text"><?php echo e(__('List All')); ?></span>
                    </a>
                </li>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $event)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('event.create') ?: 'active text-primary'); ?>" href="<?php echo e(route('event.create')); ?>">
                            <i class="fas fa-plus"></i>
                            <span class="nav-link-text"><?php echo e(__('Create New')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if(route_is_equal('event.gallery.index') && ($entity = request()->route()->event)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('event.gallery.index') ?: 'active text-primary'); ?>">
                            <i class="fas fa-photo-film"></i>
                            <span class="nav-link-text"><?php echo e(__('Gallery #:id', ['id' => is_object($entity) ? $entity?->id : ''])); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if(route_is_equal('event.schedule.index') && ($entity = request()->route()->event)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('event.schedule.index') ?: 'active text-primary'); ?>">
                            <i class="fas fa-clock"></i>
                            <span class="nav-link-text"><?php echo e(__('Schedule #:id', ['id' => is_object($entity) ? $entity?->id : ''])); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if(route_is_equal('event.users.index') && ($entity = request()->route()->event)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('event.users.index') ?: 'active text-primary'); ?>">
                            <i class="fas fa-user-group"></i>
                            <span class="nav-link-text"><?php echo e(__('Participants #:id', ['id' => is_object($entity) ? $entity?->id : ''])); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $event)): ?>
                    <?php if(route_is_equal('event.edit') && ($entity = request()->route()->event)): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(!route_active('event.edit') ?: 'active text-primary'); ?>">
                                <i class="fas fa-edit"></i>
                                <span class="nav-link-text"><?php echo e(__('Edit #:id', ['id' => is_object($entity) ? $entity?->id : ''])); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('restore', $event)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(!route_active('event.trashed') ?: 'active text-primary'); ?>" href="<?php echo e(route('event.trashed')); ?>">
                            <i class="fas fa-trash-can"></i>
                            <span class="nav-link-text"><?php echo e(__('Trashed')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/navbars/sidebar/events.blade.php ENDPATH**/ ?>