<div class="col-12 form-group">
    <label class="form-control-label" for="input-title"><?php echo e(__('Title')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('title') ? 'has-danger' : ''); ?>">
        <input type="text" name="title" id="input-title"
            class="form-control <?php echo e($errors->has('title') ? 'is-invalid' : ''); ?>" maxlength="100"
            placeholder="<?php echo e(__('Title')); ?>" value="<?php echo e(old('title', $event->title)); ?>" required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'title'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-location"><?php echo e(__('Location')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('location') ? 'has-danger' : ''); ?>">
        <input type="text" name="location" id="input-location"
            class="form-control <?php echo e($errors->has('location') ? 'is-invalid' : ''); ?>" maxlength="100"
            placeholder="<?php echo e(__('Location')); ?>" value="<?php echo e(old('location', $event->location)); ?>" required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'location'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-timezone"><?php echo e(__('Timezone')); ?></label>
    <div class="<?php echo e($errors->has('timezone') ? 'has-danger' : ''); ?>">
        <input type="text" name="timezone" id="input-timezone"
            class="form-control <?php echo e($errors->has('timezone') ? 'is-invalid' : ''); ?>" maxlength="100"
            placeholder="<?php echo e(__('Timezone')); ?>" value="<?php echo e(old('timezone', $event->timezone)); ?>">
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'timezone'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-speakers"><?php echo e(__('Speakers')); ?></label>
    <select name="speakers[]" id="input-speakers"
        class="form-control <?php echo e($errors->has('speakers') ? 'is-invalid' : ''); ?>"
        placeholder="<?php echo e(__('Please Select Speaker')); ?>" data-toggle="select" multiple>
        <option value=""><?php echo e(__('Please Select Speaker')); ?></option>
        <?php $__currentLoopData = $speakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($id); ?>" <?php if(in_array($id, old('speakers', $event->exists ? $event->speakers()->pluck('id')->toArray() : []))): echo 'selected'; endif; ?>><?php echo e($name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php echo $__env->make('alerts.feedback', ['field' => 'speakers'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-relatedEvents"><?php echo e(__('Related Events')); ?></label>
    <select name="related_events[]" id="input-relatedEvents"
        class="form-control <?php echo e($errors->has('related_events') ? 'is-invalid' : ''); ?>"
        placeholder="<?php echo e(__('Please Select Related Events')); ?>" data-toggle="select" multiple>
        <option value=""><?php echo e(__('Please Select Related Events')); ?></option>
        <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($id !== $event->id): ?>
                <option value="<?php echo e($id); ?>" <?php if(in_array($id, old('related_events', $event->exists ? $event->relatedEvents()->pluck('related_event_id')->toArray() : []))): echo 'selected'; endif; ?>><?php echo e($name); ?></option>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php echo $__env->make('alerts.feedback', ['field' => 'related_events'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-start_date"><?php echo e(__('Start Date')); ?> <sup
            class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('start_date') ? 'has-danger' : ''); ?>">
        <input type="date" name="start_date" id="input-start_date"
            class="flatpickr-start form-control <?php echo e($errors->has('start_date') ? 'is-invalid' : ''); ?>"
            placeholder="<?php echo e(__('Start Date')); ?>" value="<?php echo e(old('start_date', $event->start_date?->format('Y-m-d'))); ?>"
            required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'start_date'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-end_date"><?php echo e(__('End Date')); ?></label>
    <div class="<?php echo e($errors->has('end_date') ? 'has-danger' : ''); ?>">
        <input type="date" name="end_date" id="input-end_date"
            class="flatpickr-end form-control <?php echo e($errors->has('end_date') ? 'is-invalid' : ''); ?>"
            placeholder="<?php echo e(__('End Date')); ?>" value="<?php echo e(old('end_date', $event->end_date?->format('Y-m-d'))); ?>">
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'end_date'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>



<?php echo $__env->make('admin.components.fileinput', [
    'thumbnail' => [
        // 'delete' => asset_exists($event->banner),
        'label' => 'banner',
        'url' => $event->banner_path,
        'path' => $event->banner,
        'policy' => 'update',
        'entity' => $event::class,
        'hash' => $event->hash_id,
    ],
    'label' => 'Banner',
    'name' => 'banner',
    'recommend' => '300px * 300px',
    'required' => !$event->exists,
    'uploaded' =>
        $event->exists && $event->banner_path ? ['url' => $event->banner_path, 'path' => $event->banner] : [],
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php echo $__env->make('admin.components.fileinput', [
    'thumbnail' => $event->file_path
        ? [
            'delete' => asset_exists($event->file_path),
            'label' => 'Schedule PDF',
            'column' => 'file_path',
            'url' => $event->file_thumbnail_url,
            'path' => $event->file_path,
            'policy' => 'update',
            'entity' => $event::class,
            'hash' => $event->hash_id,
            'padding' => true,
        ]
        : [],
    'required' => false,
    'label' => 'Schedule PDF',
    'name' => 'file',
    'mimes' => 'PDF',
    'uploaded' =>
        $event->exists && $event->file_path ? ['url' => $event->file_url, 'path' => $event->file_name] : [],
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php echo $__env->make('admin.components.tinymce', ['editors' => ['Description*' => 'description'], 'model' => $event], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3"><?php echo e(__('Featured')); ?> <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_featured" value="1"
            <?php echo e(old('is_featured', $event->is_featured) ? 'checked' : ''); ?>>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3"><?php echo e(__('Enable Submit Feedback')); ?> <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="enable_submit_feedback" value="1"
            <?php echo e(old('enable_submit_feedback', $event->enable_submit_feedback) ? 'checked' : ''); ?>>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3"><?php echo e(__('Status Active')); ?> <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1"
            <?php echo e(old('is_active', $event->is_active) ? 'checked' : ''); ?>>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<?php $__env->startPush('vendor-css'); ?>
    <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/select2/dist/css/select2.min.css')); ?>"
        nonce="<?php echo e(csp_nonce('style')); ?>">
    <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/flatpickr/flatpickr.min.css')); ?>"
        nonce="<?php echo e(csp_nonce('style')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('vendor-js'); ?>
    <script src="<?php echo e(basset_url('argon/vendor/select2/dist/js/select2.full.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>">
    </script>
    <script src="<?php echo e(basset_url('argon/vendor/flatpickr/flatpickr.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        const flatpikrStart = $('.flatpickr-start').flatpickr({
            //
        });

        const flatpikrEnd = $('.flatpickr-end').flatpickr({
            //
        });

        flatpikrStart.config.onChange.push(function(selectedDates, dateStr, instance) {
            if (dateStr) {
                flatpikrEnd.set('minDate', dateStr);
                flatpikrEnd.jumpToDate(dateStr);
            }
        });

        flatpikrEnd.config.onChange.push(function(selectedDates, dateStr, instance) {
            if (dateStr) {
                //
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Event/Resources/views/admin/form.blade.php ENDPATH**/ ?>