<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e($title ?? 'Admin Dashboard'); ?> | <?php echo e(config('app.name')); ?></title>

        <!-- Favicon -->
        <link href="<?php echo e(uno()->favicon); ?>" rel="icon" type="image/png">

        <!-- Icons CSS -->
    	<link type="text/css" href="<?php echo e(basset_url('css/icons.css')); ?>" rel="stylesheet">

        <?php echo $__env->yieldPushContent('vendor-css'); ?>

        <!-- Argon CSS -->
        <link type="text/css" href="<?php echo e(basset_url('css/argon.css', mix: true)); ?>" rel="stylesheet">

        <?php echo $__env->yieldPushContent('css'); ?>
    </head>
    <body class="<?php echo e($class ?? ''); ?>">
        <?php if(auth()->guard()->check()): ?>
            <form id="logoutForm" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                <?php echo csrf_field(); ?>
            </form>
            <?php echo $__env->make('admin.layouts.navbars.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

        <div class="main-content d-flex flex-column vh-100">
            <?php if($nav ?? true): ?>
                <?php echo $__env->make('admin.layouts.navbars.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>

            <?php if($header ?? true): ?>
                <?php echo $__env->make('admin.layouts.headers.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>

            <?php if($footer ?? true): ?>
                <?php echo $__env->make('admin.layouts.footers.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>
        </div>

        <?php if(!app()->isProduction() && config('clockwork.enable')): ?>
            <div class="fixed-bottom sidenav">
                <a class="btn btn-dark m-3 px-3" href="<?php echo e(url('clockwork/app')); ?>" target="_blank" role="button" title="Clockwork">
                    <i class="fas fa-cogs"></i>
                </a>
            </div>
            <script src="<?php echo e(basset_url('https://cdn.jsdelivr.net/gh/underground-works/clockwork-browser@1/dist/metrics.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
        <?php endif; ?>

        <?php echo $__env->yieldPushContent('modals'); ?>

        <!-- Scripts -->
    	<script src="<?php echo e(basset_url('js/manifest.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    	<script src="<?php echo e(basset_url('js/vendor_jquery.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    	<script src="<?php echo e(basset_url('js/vendor_admin.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    	<script src="<?php echo e(basset_url('js/app.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>

    	<script src="<?php echo e(basset_url('argon/vendor/js-cookie/js.cookie.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    	<script src="<?php echo e(basset_url('argon/vendor/jquery.scrollbar/jquery.scrollbar.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    	<script src="<?php echo e(basset_url('argon/vendor/jquery-scroll-lock/dist/jquery-scrollLock.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>

        <?php echo $__env->yieldPushContent('vendor-js'); ?>

        <!-- Argon JS -->
        <script src="<?php echo e(basset_url('js/argon.js', mix: true)); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>

        <?php $bassetBlock = 'admin/js/elfinder-selected-file.js'; ob_start(); ?>
            <script nonce="<?php echo e(basset_nonce('script')); ?>">
                window.processELFinderSelectedFile = function (filePath, requestingFieldName) {
                    $('#' + requestingFieldName + 'ElFinderFileInput').next().html(filePath);
                    $('#' + requestingFieldName + 'ElFinderFileInput').parent().append(`<input type="hidden" name="${requestingFieldName}" value="${filePath}">`);
                };
            </script>
        <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>

        <?php $bassetBlock = 'admin/js/submit-confirmation.js'; ob_start(); ?>
            <script nonce="<?php echo e(basset_nonce('script')); ?>">
                window.listenFormNeedConfirmation = function () {
                    $('.need-confirm').on('submit', function (ev) {
                        let button = $(this).find('button[type=submit]');

                        if (confirm("<?php echo e(__('Are you sure to proceed with this action?')); ?>")) {
                            button.html('<i class="fas fa-arrows-rotate fa-spin"></i>').prop('disabled', true);
                        } else {
                            ev.preventDefault();

                            if (button.hasClass('btn-trash')) {
                                console.log(123456);

                                button.html('<i class="fas fa-trash"></i>').prop('disabled', false);
                            }
                        }
                    });
                }

                listenFormNeedConfirmation();
            </script>
        <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>

        <?php echo $__env->yieldPushContent('js'); ?>
    </body>
</html>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/layouts/base.blade.php ENDPATH**/ ?>