<div class="col-12 form-group">
    <label class="form-control-label" for="input-title"><?php echo e(__('Title')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->has('title') ? 'has-danger' : ''); ?>">
        <input type="text" name="title" id="input-title" class="form-control <?php echo e($errors->has('title') ? 'is-invalid' : ''); ?>" maxlength="100" placeholder="<?php echo e(__('Title')); ?>" value="<?php echo e(old('title', $announcement->title)); ?>" autofocus required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'title'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-message"><?php echo e(__('Message')); ?> <small class="muted">(<?php echo e(__('Max 200 Characters')); ?>)</small></label>
    <div class="<?php echo e($errors->has('message') ? 'has-danger' : ''); ?>">
        <textarea name="message" id="input-message" class="form-control <?php echo e($errors->has('message') ? 'is-invalid' : ''); ?>" maxlength="200" cols="30" rows="5"><?php echo e(old('message', $announcement->message)); ?></textarea>
    </div>
    <?php echo $__env->make('alerts.feedback', ['field' => 'message'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3"><?php echo e(__('Status Active')); ?> <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $announcement->is_active) ? 'checked' : ''); ?>>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<?php $__env->startPush('js'); ?>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Announcement/Resources/views/admin/form.blade.php ENDPATH**/ ?>