<?php $announcement = app(Modules\Announcement\Entities\Announcement::class); ?>



<?php $__env->startSection('header'); ?>
    <?php $__env->startComponent('admin.layouts.headers.breadcrumbs'); ?>
        <?php $__env->slot('title'); ?>
            <i class="fas fa-bullhorn fa-lg"></i>
        <?php $__env->endSlot(); ?>

        <li class="breadcrumb-item"><a href="<?php echo e(route('announcement.index')); ?>"><?php echo e(__('Announcements')); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('List All')); ?></li>

        <?php $__env->slot('buttons'); ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $announcement)): ?>
                <a href="<?php echo e(route('announcement.create')); ?>" class="btn btn-sm btn-neutral"><?php echo e(__('Create New')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('export', $announcement)): ?>
                <a href="<?php echo e(route('announcement.export', request()->query())); ?>" class="btn btn-sm btn-primary"><?php echo e(__('Export Excel')); ?></a>
            <?php endif; ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="position-relative container-fluid mt--8">
    <div class="card">
        <?php $__env->startComponent('admin.components.filter'); ?>
            <?php $__env->slot('status', true); ?>
        <?php echo $__env->renderComponent(); ?>

        <div class="py-4">
            <table id="tableAnnouncement" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['update', 'delete'], $announcement)): ?>
                            <th><?php echo e(__('Actions')); ?></th>
                        <?php endif; ?>
                        <th><?php echo e(__('Title')); ?></th>
                        <th><?php echo e(__('Message')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Created At')); ?></th>
                        <th><?php echo e(__('Updated At')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.datatables.table', [
    'name' => 'Announcement',
    'route' => route('announcement.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $announcement, can: ['update', 'delete']),
        get_dt_column_config('title'),
        get_dt_column_config('message'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Announcements Management'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Announcement/Resources/views/admin/index.blade.php ENDPATH**/ ?>