<?php $static_page = app(App\Model\StaticPage::class); ?>



<?php $__env->startSection('header'); ?>
    <?php $__env->startComponent('admin.layouts.headers.breadcrumbs'); ?>
        <?php $__env->slot('title'); ?>
            <i class="fas fa-pager fa-lg"></i>
        <?php $__env->endSlot(); ?>

        <li class="breadcrumb-item"><a href="<?php echo e(route('static-page.index')); ?>"><?php echo e(__('Pages')); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('List All')); ?></li>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $static_page)): ?>
            <?php $__env->slot('buttons'); ?>
                <a href="<?php echo e(route('static-page.create')); ?>" class="btn btn-sm btn-neutral"><?php echo e(__('Create New')); ?></a>
            <?php $__env->endSlot(); ?>
        <?php endif; ?>
    <?php echo $__env->renderComponent(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt--8">
    <div class="card">
        <?php $__env->startComponent('admin.components.filter'); ?>
            <?php $__env->slot('status', true); ?>
        <?php echo $__env->renderComponent(); ?>

        <div class="py-4">
            <table id="tableStaticPage" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view', 'update', 'delete'], $static_page)): ?>
                            <th><?php echo e(__('Actions')); ?></th>
                        <?php endif; ?>
                        <th><?php echo e(__('Title')); ?></th>
                        
                        <th><?php echo e(__('Content')); ?></th>
                        <th><?php echo e(__('Static')); ?></th>
                        
                        
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Created At')); ?></th>
                        <th><?php echo e(__('Updated At')); ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.datatables.table', [
    'name' => 'StaticPage',
    'route' => route('static-page.index'),
    'reorder' => route('static-page.reorder'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $static_page, can: ['view', 'update', 'delete']),
        get_dt_column_config('title'),
        // get_dt_column_config('slug'),
        get_dt_column_config('editor_content'),
        get_dt_column_config('is_static', searchable: false),
        // get_dt_column_config('on_menu'),
        // get_dt_column_config('on_footer'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Pages Management'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/staticpage/index.blade.php ENDPATH**/ ?>