<div class="d-flex align-items-center">
    <?php if(isset($copy_text) && isset($copy_title)): ?>
        <button type="button" data-copy="<?php echo e($copy_text); ?>" title="<?php echo e($copy_title); ?>" class="btn-copy table-action border-0 bg-transparent px-0 text-dark mr-2">
            <i class="fas fa-copy"></i>
        </button>
    <?php endif; ?>

    <?php if(isset($show_route)): ?>
        <?php if(admin()->can($show_gate ?? 'view', $row)): ?>
            <a href="<?php echo e(route($show_route, $params = ($row->slug ?: ($row->hash_id ?: $row->id)))); ?>" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Show" title="Show" target="<?php echo e($show_target ?? '_blank'); ?>">
                <i class="fas fa-eye"></i>
            </a>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(isset($external_route)): ?>
        <a href="<?php echo e($external_route); ?>" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Open" title="Open" target="<?php echo e($external_target ?? '_blank'); ?>">
            <i class="fas fa-arrow-up-right-from-square"></i>
        </a>
    <?php endif; ?>

    <?php if(isset($update_route)): ?>
        <?php if($allowed_update ?? admin()->can($update_gate ?? 'update', $row)): ?>
            <a href="<?php echo e(route($update_route, $params ??= ($row->hash_id ?: $row->id))); ?>" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Edit" title="Edit">
                <i class="fas fa-edit"></i>
            </a>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(isset($gallery_route)): ?>
        <a href="<?php echo e(route($gallery_route, $params ??= ($row->hash_id ?: $row->id))); ?>" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Gallery" title="Gallery">
            <i class="fas fa-photo-film"></i>
        </a>
    <?php endif; ?>

    <?php if(isset($schedule_route)): ?>
        <a href="<?php echo e(route($schedule_route, $params ??= ($row->hash_id ?: $row->id))); ?>" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Schedule" title="Schedule">
            <i class="fas fa-clock"></i>
        </a>
    <?php endif; ?>

    <?php if(isset($participants_route)): ?>
        <a href="<?php echo e(route($participants_route, $params ??= ($row->hash_id ?: $row->id))); ?>" class="table-action text-primary mr-2" data-placement="right" data-toggle="tooltip" data-original-title="Participants" title="Participants">
            <i class="fas fa-user-group"></i>
        </a>
    <?php endif; ?>

    <?php if(isset($delete_route)): ?>
        <?php if($allowed_delete ?? admin()->can($delete_gate ?? 'delete', $row)): ?>
            <form action="<?php echo e(route($delete_route, $params ??= ($row->hash_id ?: $row->id))); ?>" class="need-confirm" method="post">
                <?php echo method_field('delete'); ?>
                <?php echo csrf_field(); ?>
                <button type="submit" class="table-action table-action-delete border-0 bg-transparent px-0" data-placement="right" data-toggle="tooltip" data-original-title="Delete" title="Delete">
                    <i class="fas fa-trash"></i>
                </button>
            </form>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(isset($restore_route)): ?>
        <?php if(admin()->can($restore_gate ?? 'restore', $row)): ?>
            <form action="<?php echo e(route($restore_route, $row->id)); ?>" class="need-confirm" method="post">
                <?php echo csrf_field(); ?>
                <button type="submit" class="table-action border-0 bg-transparent px-0" data-placement="right" data-toggle="tooltip" data-original-title="Restore" title="Restore">
                    <i class="fas fa-arrow-rotate-left"></i>
                </button>
            </form>
        <?php endif; ?>
    <?php endif; ?>

    <?php if(($unread ?? false) && !$row->has_read): ?>
        <span class="badge badge-pill badge-info align-top ml-2"><?php echo e(__('New')); ?></span>
    <?php endif; ?>
</div>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/datatables/actions.blade.php ENDPATH**/ ?>