<?php $__env->startPush('vendor-css'); ?>
    <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>" nonce="<?php echo e(csp_nonce('style')); ?>">

    <?php if(isset($reorder)): ?>
        <link rel="stylesheet" href="<?php echo e(basset_url('argon/vendor/datatables.net/rowreorder/dataTables.rowReorder.min.css')); ?>" nonce="<?php echo e(csp_nonce('style')); ?>">
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('vendor-js'); ?>
    <script src="<?php echo e(basset_url('argon/vendor/datatables.net/js/jquery.dataTables.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    <script src="<?php echo e(basset_url('argon/vendor/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>

    <?php if(isset($reorder)): ?>
        <script src="<?php echo e(basset_url('argon/vendor/datatables.net/rowreorder/dataTables.rowReorder.min.js')); ?>" nonce="<?php echo e(csp_nonce('script')); ?>"></script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        const dt = $('#table<?php echo e($name); ?>').DataTable({
            <?php if(isset($reorder)): ?>
            rowReorder: {
                dataSrc: 'position'
            },
            <?php endif; ?>
            scrollX: true,
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?php echo e($route); ?>",
                data: <?php echo json_encode(request()->query()); ?>,
                beforeSend: function() {
                    $('.dataTables_paginate, .dataTables_length, .dataTables_filter').addClass('pe-none opacity-5');
                },
                complete: function(data) {
                    $('.dataTables_paginate, .dataTables_length, .dataTables_filter').removeClass('pe-none opacity-5');

                    window.listenFormNeedConfirmation();

                    $('[data-toggle="tooltip"]').tooltip();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (errorThrown == 'Unauthorized') {
                        window.location = "<?php echo e(route('login')); ?>";
                    } else {
                        alert(errorThrown);
                        window.location = "<?php echo e(route('home')); ?>";
                    }
                },
            },
            language: {
                paginate: {
                    previous: "<i class='fas fa-angle-left'>",
                    next: "<i class='fas fa-angle-right'>",
                },
            },
            order: [<?php echo json_encode($orders ?? [0, 'desc']); ?>],
            columns: <?php echo json_encode(array_values(array_filter($columns))); ?>

        });

        <?php if(isset($reorder)): ?>
            dt.on('row-reorder', function (e, details) {
                if (details.length) {
                    let rows = [];

                    details.forEach(function (element) {
                        var rowData = dt.row(element.node).data();

                        rows.push({
                            id: rowData['id'],
                            position: element.newPosition
                        });
                    });

                    $.ajax({
                        method: 'post',
                        url: "<?php echo e($reorder); ?>",
                        data: { rows }
                    }).done(function() {
                        dt.ajax.reload();
                    });
                }
            });
        <?php endif; ?>
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/resources/views/admin/datatables/table.blade.php ENDPATH**/ ?>