<?php $participant = app(Modules\Participant\Entities\Participant::class); ?>



<?php $__env->startSection('header'); ?>
    <?php $__env->startComponent('admin.layouts.headers.breadcrumbs'); ?>
        <?php $__env->slot('title'); ?>
            <i class="fas fa-user-group fa-lg"></i>
        <?php $__env->endSlot(); ?>

        <li class="breadcrumb-item"><a href="<?php echo e(route('participant.index')); ?>"><?php echo e(__('Participants')); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('List All')); ?></li>

        <?php $__env->slot('buttons'); ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', $participant)): ?>
                <a href="<?php echo e(route('participant.create')); ?>" class="btn btn-sm btn-neutral"><?php echo e(__('Create New')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('export', $participant)): ?>
                <a href="<?php echo e(route('participant.export', request()->query())); ?>" class="btn btn-sm btn-neutral"><?php echo e(__('Export Excel')); ?></a>
            <?php endif; ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="position-relative container-fluid mt--8">
    <?php if(request()->has('event')): ?>
        <h1 class="text-white mb-3"><?php echo e(__('Event #:id Participants', ['id' => request()->query('event')])); ?></h1>
    <?php endif; ?>

    <div class="card">
        <?php $__env->startComponent('admin.components.filter'); ?>
            <?php $__env->slot('status', null); ?>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterEvent"><?php echo e(__('Filter Event')); ?></label>
                <select class="form-control" name="event" id="filterEvent" data-toggle="select">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php if(request()->query('event') == $id): echo 'selected'; endif; ?>><?php echo e($name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        <?php echo $__env->renderComponent(); ?>

        <div class="py-4">
            <table id="tableParticipant" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['update', 'delete'], $participant)): ?>
                            <th><?php echo e(__('Actions')); ?></th>
                        <?php endif; ?>
                        <th><?php echo e(__('Event')); ?></th>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('Designation')); ?></th>
                        <th><?php echo e(__('Company')); ?></th>
                        <th><?php echo e(__('Email')); ?></th>
                        <th><?php echo e(__('Phone No.')); ?></th>
                        <th><?php echo e(__('Created At')); ?></th>
                        
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.datatables.table', [
    'name' => 'Participant',
    'route' => route('participant.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $participant, can: ['update', 'delete']),
        get_dt_column_config('event', 'event.title'),
        get_dt_column_config('name'),
        get_dt_column_config('designation'),
        get_dt_column_config('company'),
        get_dt_column_config('email'),
        get_dt_column_config('contact_no'),
        get_dt_column_config('created_at', searchable: false),
        // get_dt_column_config('updated_at', searchable: false),
    ]
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->startPush('js'); ?>
    <script nonce="<?php echo e(csp_nonce('script')); ?>">
        $("#filterEvent").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('event', $(this).val());
            } else {
                urlParams.delete('event');
            }

            window.location.search = urlParams;
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.base', [
    'title' => __('Participants Management'),
], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Participant/Resources/views/admin/index.blade.php ENDPATH**/ ?>