<div class="col-12 form-group">
    <label class="form-control-label" for="input-date"><?php echo e(__('Date')); ?> <sup class="text-danger">*</sup></label>
    <select name="date" id="input-date" class="form-control <?php echo e($errors->{$bag}->has('date') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Please Select Date')); ?>" required>
        <option value=""><?php echo e(__('Please Select Date')); ?></option>
        <?php $__currentLoopData = $event->dateRange(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($date); ?>" <?php if(old('date', $schedule?->date) == $date): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php echo $__env->make('alerts.feedback', ['bag' => $bag, 'field' => 'date'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-title"><?php echo e(__('Title')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->{$bag}->has('title') ? 'has-danger' : ''); ?>">
        <textarea name="title" id="input-title" class="form-control <?php echo e($errors->{$bag}->has('title') ? 'is-invalid' : ''); ?>" cols="30" rows="5" placeholder="<?php echo e(__('Title')); ?>" required><?php echo e(old('title', $schedule?->title)); ?></textarea>
    </div>
    <?php echo $__env->make('alerts.feedback', ['bag' => $bag, 'field' => 'title'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 px-0">
    <?php echo $__env->make('admin.components.tinymce', ['editors' => ['Description' => 'description'], 'model' => $schedule, 'append' => ($form ?? false) ? '-modal' : ''], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-venue"><?php echo e(__('Venue')); ?></label>
    <div class="<?php echo e($errors->{$bag}->has('venue') ? 'has-danger' : ''); ?>">
        <input type="text" name="venue" id="input-venue" class="form-control <?php echo e($errors->{$bag}->has('venue') ? 'is-invalid' : ''); ?>" maxlength="100" placeholder="<?php echo e(__('Venue')); ?>" value="<?php echo e(old('venue', $schedule?->venue)); ?>">
    </div>
    <?php echo $__env->make('alerts.feedback', ['bag' => $bag, 'field' => 'venue'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-start_time"><?php echo e(__('Start Time')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->{$bag}->has('start_time') ? 'has-danger' : ''); ?>">
        <input type="text" name="start_time" id="input-start_time" class="flatpickr-<?php echo e($bag); ?>-start form-control bg-white <?php echo e($errors->{$bag}->has('start_time') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Start Time')); ?>" value="<?php echo e(old('start_time', $schedule?->start_time)); ?>" required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['bag' => $bag, 'field' => 'start_time'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-end_time"><?php echo e(__('End Time')); ?> <sup class="text-danger">*</sup></label>
    <div class="<?php echo e($errors->{$bag}->has('end_time') ? 'has-danger' : ''); ?>">
        <input type="text" name="end_time" id="input-end_time" class="flatpickr-<?php echo e($bag); ?>-end form-control bg-white <?php echo e($errors->{$bag}->has('end_time') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('End Time')); ?>" value="<?php echo e(old('end_time', $schedule?->end_time)); ?>" required>
    </div>
    <?php echo $__env->make('alerts.feedback', ['bag' => $bag, 'field' => 'end_time'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-speakers"><?php echo e(__('Speakers')); ?></label>
    <select name="speakers[]" id="input-speakers" class="select2-<?php echo e($bag); ?> form-control <?php echo e($errors->{$bag}->has('speakers') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Please Select Speaker')); ?>" multiple>
        <option value=""><?php echo e(__('Please Select Speaker')); ?></option>
        <?php $__currentLoopData = $speakers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($id); ?>" <?php if(in_array($id, old('speakers', $schedule?->exists ? $schedule?->speakers()->pluck('id')->toArray() : []))): echo 'selected'; endif; ?>><?php echo e($name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php echo $__env->make('alerts.feedback', ['bag' => $bag, 'field' => 'speakers'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-tags"><?php echo e(__('Tags')); ?></label>
    <select name="tags" id="input-tags" class="form-control <?php echo e($errors->{$bag}->has('tags') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('Please Select Tag')); ?>">
        <option value=""><?php echo e(__('Please Select Tag')); ?></option>
        <?php $__currentLoopData = $schedule::listTags(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($val); ?>" <?php if(old('tags', $schedule?->tags) == $val): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php echo $__env->make('alerts.feedback', ['bag' => $bag, 'field' => 'tags'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3"><?php echo e(__('Status Active')); ?> <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $schedule?->is_active) ? 'checked' : ''); ?>>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

<?php if(isset($form)): ?>
    <?php echo csrf_field(); ?>
    <?php echo method_field('put'); ?>

    <input type="hidden" name="id" value="<?php echo e($schedule->id); ?>">
    <input type="hidden" name="hash" value="<?php echo e($schedule->hash_id); ?>">

    <div class="col-12 text-center mt-4">
        <button type="submit" class="btn btn-success">
            <i class="fas fa-save mr-2"></i><?php echo e(__('Update')); ?>

        </button>
    </div>
<?php endif; ?>
<?php /**PATH /home/ifsb/public_html/portal.ifsb.org/Modules/Event/Resources/views/admin/schedule/form.blade.php ENDPATH**/ ?>