<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

use Illuminate\Support\Facades\Route;
use Modules\Event\Entities\Event;
use Symfony\Component\HttpFoundation\Response;

Route::get('/', function () {
    return to_route('home');
})->name('index');

Route::get('event/{event}/download', function (Event $event) {
    abort_unless(disk_public()->exists($event->file_path), Response::HTTP_NOT_FOUND);
    return disk_public()->download($event->file_path, $event->file_name);
})->name('front.event.download');
