<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use App\Http\Controllers\Api\AllPagesController;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\AppStatusController;
use App\Http\Controllers\Api\DeviceRegisterController;
use App\Http\Controllers\Api\ShowPageController;
use App\Http\Controllers\Api\SubmitEnquiryController;
use App\Providers\RouteServiceProvider;
use Symfony\Component\HttpFoundation\Response;

Route::middleware([
    // NOTE: check for ApiController for logic checking
])->prefix(RouteServiceProvider::API_VERSION)->group(function () {
    Route::get('status', AppStatusController::class);
    Route::post('register', DeviceRegisterController::class);
    Route::post('enquiry', SubmitEnquiryController::class);

    Route::prefix('pages')->group(function () {
        Route::get('/', AllPagesController::class);
        Route::get('show/{slug}', ShowPageController::class);
    });
});

Route::fallback(function() {
    return (new ApiController())->jsonError(Response::HTTP_NOT_FOUND, __('Page not found. If error persists, please contact admin.'));
});
