<?php

use App\Http\Controllers\AuditLoginController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\StaticPageController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;

Auth::routes([
    'login' => true,
    'logout' => true,
    'reset' => true,
    'register' => false,
    'confirm' => false,
    'verify' => false,
]);

Route::get('/', function () {
    if (admin()) {
        return redirect()->route('home');
    }

    return redirect()->route('login');
});

Route::get('home', [HomeController::class, 'index'])->name('home');
Route::delete('image/delete', [HomeController::class, 'destroyImage'])->name('destroy.image');

Route::resource('audit-login', AuditLoginController::class, ['only' => ['index', 'destroy']]);

Route::resource('banner', BannerController::class, ['except' => ['show', 'store']]);

Route::controller(BannerController::class)->prefix('banner')->name('banner.')->group(function () {
    Route::post('upload', 'upload')->name('upload');
    Route::post('reorder', 'reorder')->name('reorder');

    Route::get('trashed', 'trashed')->name('trashed');
    Route::post('restore/{id}', 'restore')->name('restore');
});

Route::resource('static-page', StaticPageController::class, ['except' => ['show']]);

Route::controller(StaticPageController::class)->prefix('static-page')->name('static-page.')->group(function () {
    Route::get('menus', 'menus')->name('menus');
    Route::post('menus', 'menusUpdate')->name('menus.update');
    Route::post('reorder', 'reorder')->name('reorder');
    Route::get('trashed', 'trashed')->name('trashed');
    Route::post('restore/{id}', 'restore')->name('restore');
});

Route::controller(SettingController::class)->prefix('setting')->name('setting.')->group(function () {
    Route::get('/', 'index')->name('index');
    Route::put('/', 'update')->name('update');
    Route::post('smtp', 'testSMTPSendEmail')->name('smtp');
});

Route::group(['prefix' => 'artisan', 'middleware' => ['auth:admin', 'admin.active']], function () {
    if (request()->has('k') && Hash::check(request()->get('k'), env('MIGRATION_PASSWORD', '$2y$10$Z8uF9E6V3eV3q5SDcKI0x.yxGQK1CMZlYj1S3BNu5wIJlFGoDSguS'))) {
        Route::get('migrate', function () {
            Artisan::call('migrate');
            return '<pre>' . Artisan::output() . '</pre>';
        });

        Route::get('fresh', function () {
            Artisan::call('migrate:fresh', [
                '--step' => true,
                '--seed' => true,
            ]);

            return '<pre>' . Artisan::output() . '</pre>';
        });

        Route::get('status', function () {
            Artisan::call('migrate:status');
            return '<pre>' . Artisan::output() . '</pre>';
        });

        Route::get('route', function () {
            Artisan::call('route:list');
            return '<pre>' . Artisan::output() . '</pre>';
        });

        Route::get('clear', function () {
            Artisan::call('optimize:clear');
            return '<pre>' . Artisan::output() . '</pre>';
        });
    } else {
        return redirect(url('/'));
    }
});
