<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ __('elFinder 2.0') }}</title>

    <!-- jQuery and jQuery UI (REQUIRED) -->
    <link rel="stylesheet" href="{{ basset_url('https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/smoothness/jquery-ui.css') }}" nonce="{{ csp_nonce('style') }}">

    <script src="{{ basset_url('https://ajax.googleapis.com/ajax/libs/jquery/1.11.0/jquery.min.js') }}"></script>
    <script src="{{ basset_url('https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js') }}"></script>

    <!-- elFinder CSS (REQUIRED) -->
    <link rel="stylesheet" type="text/css" href="{{ basset_url($dir.'/css/elfinder.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ basset_url($dir.'/css/theme.min.css') }}">

    @bassetBlock('admin/css/elfinder-custom-style.css')
        <style type="text/css">
            .elfinder-navdock .ui-resizable-n {
                display: none;
            }

            .elfinder-quicklook-titlebar-icon.elfinder-titlebar-button-right .ui-icon {
                margin-top: 0;
            }

            .elfinder-dialog-title {
                width: 100%;
                text-overflow: ellipsis;
            }

            .elfinder-icon-minimize {
                display: none
            }

            .elfinder-button-menu.elfinder-button-search-menu {
                display: none !important;
            }

            .elfinder-contextmenu-item.ui-state-active {
                background: #2196f3;
            }

            .elfinder-button-search input {
                box-sizing: border-box !important;
                padding: 0 35px !important;
            }

            .elfinder .elfinder-toast > div:before {
                font-size: 35px;
                top: 0;
            }
        </style>
    @endBassetBlock()

    <!-- elFinder JS (REQUIRED) -->
    <script src="{{ basset_url($dir.'/js/elfinder.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>

    @if ($locale)
        <!-- elFinder translation (OPTIONAL) -->
        <script src="{{ basset_url($dir."/js/i18n/elfinder.$locale.js") }}" nonce="{{ csp_nonce('script') }}"></script>
    @endif

    <!-- elFinder initialization (REQUIRED) -->
    <script type="text/javascript" nonce="{{ csp_nonce('script') }}">
        var FileBrowserDialogue = {
            init: function() {
                // Here goes your code for setting your custom things onLoad.
            },
            mySubmit: function (file) {
                window.parent.postMessage({
                    mceAction: 'fileSelected',
                    data: {
                        file: file
                    }
                }, '*');
            }
        };

        $().ready(function() {
            var elf = $('#elfinder').elfinder({
                height: '100%',
                onlyMimes: {!! json_encode(explode(',', env('ELFINDER_UPLOAD_ALLOW_MIMES', 'image,video,application/pdf'))) !!},
                ui: ['toolbar', 'tree', 'path', 'stat'],
                uiOptions: {
                    // toolbar configuration
                    toolbar : [
                        ['home', 'back', 'forward', 'up', 'reload'],
                        // ['netmount'],
                        [
                            'mkdir',
                            // 'mkfile',
                            'upload'
                        ],
                        ['open', 'download', 'getfile'],
                        ['undo', 'redo'],
                        [
                            'copy', 'cut', 'paste', 'rm', 'empty',
                            // 'hide'
                        ],
                        [
                            'duplicate', 'rename',
                            // 'edit', 'resize', 'chmod'
                        ],
                        // ['selectall', 'selectnone', 'selectinvert'],
                        [
                            'quicklook',
                            'info'
                        ],
                        // ['extract', 'archive'],
                        ['search'],
                        ['view', 'sort'],
                        // ['preference', 'help'],
                        // ['fullscreen']
                    ],
                },
                contextmenu: {
                    navbar: ['open', 'opennew', 'download', '|', 'upload', 'mkdir', '|', 'copy', 'cut', 'paste', 'duplicate', '|', 'rm', 'empty', '|', 'rename'],
                    cwd: ['undo', 'redo', '|', 'back', 'up', 'reload', '|', 'upload', 'mkdir', 'paste', '|', 'empty', '|', 'view', 'sort', 'selectall'],
                    files: ['getfile', '|', 'open', 'opennew', 'download', 'opendir', '|', 'upload', 'mkdir', '|', 'copy', 'cut', 'paste', 'duplicate', '|', 'rm', 'empty', '|', 'rename', '|', 'selectall', '|', 'quicklook', 'info']
                },
                commandsOptions: {
                    search: {
                        searchTypes: {}
                    }
                },
                resizable: false,
                // set your elFinder options here
                @if ($locale)
                    lang: '{{ $locale }}', // locale
                @endif
                customData: {
                    _token: '{{ csrf_token() }}'
                },
                url: '{{ route("elfinder.connector") }}',  // connector URL
                soundPath: '{{ asset($dir.'/sounds') }}',
                getFileCallback: function(file) { // editor callback
                    @if (request()->input('id'))
                        window.parent.opener.processELFinderSelectedFile(file.path, '{{ request()->input('id') }}');
                        window.close();
                    @else
                        FileBrowserDialogue.mySubmit(file); // pass selected file path to TinyMCE
                    @endif
                }
            }).elfinder('instance');
        });
    </script>
</head>
<body>

<!-- Element where elFinder will be created (REQUIRED) -->
<div id="elfinder"></div>

</body>
</html>
