@extends('admin.layouts.base', ['class' => 'bg-secondary', 'nav' => false, 'footer' => false])

@section('header')
    <div class="row justify-content-center">
        <div class="col-8 col-sm-6 col-md-4 col-xl-3 mb-5">
            <a href="{{ route('index') }}" title="Home">
                <img src="{{ uno()->logo }}" alt="" class="img-center img-fluid">
            </a>
        </div>
    </div>
@endsection

@section('content')
    <div class="container mt--8 pb-5">
        <div class="row justify-content-center">
            <div class="col-lg-5 col-md-7">
                <div class="card bg-secondary shadow border-0">
                    <div class="card-header bg-transparent py-4">
                        <h1 class="text-uppercase text-center mb-0">{{ __('Reset Password') }}</h1>
                    </div>
                    <div class="card-body px-lg-5 py-lg-5">
                        <form role="form" method="POST" action="{{ route('password.update') }}" id="reCaptchaForm">
                            @csrf
                            @honeypot

                            @include('alerts.success')
                            @include('alerts.errors')

                            <input type="hidden" name="token" value="{{ $token }}">

                            <div class="form-group{{ $errors->has('email') ? ' has-danger' : '' }}">
                                <div class="input-group input-group-alternative">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                                    </div>
                                    <input class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" placeholder="{{ __('Email') }}" type="email" name="email" value="{{ $email ?? old('email') }}" required readonly>
                                </div>
                            </div>
                            <div class="form-group{{ $errors->has('password') ? ' has-danger' : '' }}">
                                <div class="input-group input-group-alternative">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-unlock-alt"></i></span>
                                    </div>
                                    <input class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" placeholder="{{ __('Password') }}" type="password" required autofocus>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="input-group input-group-alternative">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-unlock-alt"></i></span>
                                    </div>
                                    <input class="form-control" placeholder="{{ __('Confirm Password') }}" type="password" name="password_confirmation" required>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="g-recaptcha btn btn-primary my-4"
                                    data-sitekey="{{ config('recaptcha.api_site_key') }}"
                                    data-callback="onSubmitCaptcha"
                                    data-action="submit">{{ __('Reset Password') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('css')
    <script src="https://www.recaptcha.net/recaptcha/api.js?render={{ config('recaptcha.api_site_key') }}" async defer nonce="{{ csp_nonce('script') }}"></script>
@endpush
