@extends('admin.layouts.base', [
    'title' => __('Menus Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-sitemap fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('static-page.index') }}">{{ __('Pages') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Menus') }}</li>

        @slot('buttons')
            <a href="{{ route('static-page.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-12 col-md-7">
                @component('admin.components.card')
                    @slot('title', __('Header Menus'))

                    <div id="menus-sortable" class="list-group nested-sortable">
                        @foreach ($menus as $menu)
                            <div class="list-group-item border nested-padding" data-id="{{ $menu->id }}">
                                <div class="d-flex align-items-center mt-2 ml-2">
                                    @can('update', $menu)
                                        <div class="grabbing mr-3" data-placement="right" data-toggle="tooltip" data-original-title="Drag" title="Drag">
                                            <i class="fas fa-arrows-alt text-primary"></i>
                                        </div>

                                        <a href="{{ route('static-page.edit', $menu) }}" class="mr-2 pr-1" data-placement="right" data-toggle="tooltip" data-original-title="Edit" title="Edit">
                                            <i class="fas fa-edit text-primary"></i>
                                        </a>
                                    @endcan

                                    @can('delete', $menu)
                                        <form action="{{ route('static-page.destroy', $menu) }}" class="need-confirm mr-3" method="post">
                                            @method('delete')
                                            @csrf
                                            <button type="submit" class="btn-trash table-action table-action-delete border-0 bg-transparent px-0" data-placement="right" data-toggle="tooltip" data-original-title="Delete" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    @endcan

                                    <span>{{ $menu->title }}</span>

                                    @if (!$menu->is_active)
                                        <span class="badge badge-sm badge-danger ml-2">{{ __('Inactive') }}</span>
                                    @endif
                                </div>

                                @include('admin.staticpage.child', ['menu' => $menu])
                            </div>
                        @endforeach
                    </div>

                    <form method="post" action="{{ route('static-page.menus') }}">
                        @csrf
                        <input type="hidden" name="menus" id="input-menus" value="">
                        <div class="text-center mt-4">
                            <button type="submit" id="menus-update" class="btn btn-success" disabled>
                                <i class="fas fa-save mr-2"></i> {{ __('Update') }}
                            </button>
                        </div>
                    </form>
                @endcomponent
            </div>
            <div class="col-12 col-md-5">
                @component('admin.components.card')
                    <div class="py-2"><i class="fas fa-comment-alt-lines text-primary mr-3"></i> {{ __('Click the edit button to edit the menu page.') }}</div>
                    <div class="py-2"><i class="fas fa-comment-alt-lines text-primary mr-3"></i> {{ __('Drag and drop the menu bar to sort it.') }}</div>
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
    @bassetBlock('admin/css/header-menus-sortable.css')
        <style>
            .nested-sortable {
                padding: 5px;
                font-size: 14px;
            }

            .nested-padding {
                margin-top: 5px;
                padding: 8px;
            }

            .list-group-item+.list-group-item {
                border-top-width: 1px;
            }

            .grabbing {
                cursor: grab;
            }
        </style>
    @endBassetBlock()
@endpush

@push('vendor-js')
    <script src="{{ basset_url('https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush

@push('js')
    @bassetBlock('admin/js/header-menus-sortable.js')
        <script nonce="{{ basset_nonce('script') }}">
            $(document).ready(function() {
                window.listenFormNeedConfirmation();

                var nestedSortables = document.getElementsByClassName('nested-sortable');

                for (var i = 0; i < nestedSortables.length; i++) {
                    new Sortable(nestedSortables[i], {
                        handle: '.grabbing',
                        group: 'nested',
                        animation: 150,
                        fallbackOnBody: true,
                        swapThreshold: 0.65,
                        onMove(event) {
                            // NOTE: to limit up to 2nd level menu only
                            const lvl = $(event.to).parents('.nested-sortable').length;

                            // NOTE: to block nested when itself have children
                            const children = $(event.dragged).find('.nested-padding').length;

                            if (lvl > 1 || children > 0) {
                                return false;
                            }
                        },
                        onEnd: handleSortEnd
                    });
                }
            });

            function handleSortEnd(event) {
                var arraySortable = [];
                var menuSortable = $('#menus-sortable');
                var menuSortableCount = menuSortable.find('.nested-padding').length;

                var findChild = function(index, item, parent) {
                    if (arraySortable.length == menuSortableCount) {
                        return;
                    }

                    if (item) {
                        var obj = {};
                        var id = $(item).data('id');

                        obj[parent] = id;
                        arraySortable.push(obj);

                        $(item).find('.nested-sortable').children('.nested-padding').each(function(index, item) {
                            findChild(index, item, id);
                        });
                    }
                }

                menuSortable.children('.nested-padding').each(function(index, item) {
                    findChild(index, item, 0);
                });

                if (arraySortable.length) {
                    $('#input-menus').val(JSON.stringify(arraySortable));
                    $('#menus-update').prop('disabled', false);
                } else {
                    $('#input-menus').val('');
                    $('#menus-update').prop('disabled', true);
                }
            }
        </script>
    @endBassetBlock()
@endpush
