@inject('static_page', App\Model\StaticPage::class)

@extends('admin.layouts.base', [
    'title' => __('Pages Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-pager fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('static-page.index') }}">{{ __('Pages') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @can('create', $static_page)
            @slot('buttons')
                <a href="{{ route('static-page.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endslot
        @endcan
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', true)
        @endcomponent

        <div class="py-4">
            <table id="tableStaticPage" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['view', 'update', 'delete'], $static_page)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Title') }}</th>
                        {{-- <th>{{ __('Slug') }}</th> --}}
                        <th>{{ __('Content') }}</th>
                        <th>{{ __('Static') }}</th>
                        {{-- <th>{{ __('On Menu') }}</th> --}}
                        {{-- <th>{{ __('On Footer') }}</th> --}}
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'StaticPage',
    'route' => route('static-page.index'),
    'reorder' => route('static-page.reorder'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $static_page, can: ['view', 'update', 'delete']),
        get_dt_column_config('title'),
        // get_dt_column_config('slug'),
        get_dt_column_config('editor_content'),
        get_dt_column_config('is_static', searchable: false),
        // get_dt_column_config('on_menu'),
        // get_dt_column_config('on_footer'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])
