<div class="col-md form-group">
    <label class="form-control-label" for="input-title">{{ __('Title') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('title') ? 'has-danger' : '' }}">
        <input type="text" name="title" id="input-title" class="form-control {{ $errors->has('title') ? 'is-invalid' : '' }}" placeholder="{{ __('Title') }}" value="{{ old('title', $static_page->title) }}" autofocus required @readonly($unsluggable)>
    </div>
    @include('alerts.feedback', ['field' => 'title'])
</div>

{{-- <div id="slugWrapper" class="col-md-6 form-group">
    <label class="form-control-label" for="input-slug">{{ __('Unique Slug') }} <sup class="text-danger">*</sup> <small class="text-muted">({{ __('should contain letters and dashes only') }})</small></label>
    <div class="input-group {{ $errors->has('slug') ? 'has-danger' : '' }}">
        <div class="input-group-prepend">
            <span class="input-group-text py-2 text-muted">{{ route('index') }}/</span>
        </div>
        <input type="text" name="slug" id="input-slug" class="form-control {{ $errors->has('slug') ? 'is-invalid' : '' }}" placeholder="{{ __('Unique Slug') }}" value="{{ old('slug', $static_page->slug) }}" @readonly($unsluggable)>
    </div>
    @include('alerts.feedback', ['field' => 'slug'])
</div> --}}

{{-- <div id="metaDescWrapper" class="col-12 form-group">
    <label class="form-control-label" for="input-description">{{ __('Meta Description') }}</label>
    <div class="{{ $errors->has('description') ? 'has-danger' : '' }}">
        <textarea name="description" id="input-description" class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" placeholder="{{ __('Meta Description') }}" rows="3">{{ old('description', $static_page->description) }}</textarea>
    </div>
    @include('alerts.feedback', ['field' => 'description'])
</div> --}}

{{-- <div id="metaKeywordWrapper" class="col-12 form-group">
    <label class="form-control-label" for="input-keywords">{{ __('Meta Keywords') }}</label>
    <div class="{{ $errors->has('keywords') ? 'has-danger' : '' }}">
        <input type="text" name="keywords" id="input-keywords" class="form-control {{ $errors->has('keywords') ? 'is-invalid' : '' }}" placeholder="{{ __('Meta Keywords') }}" value="{{ old('keywords', $static_page->keywords) }}">
    </div>
    @include('alerts.feedback', ['field' => 'keywords'])
</div> --}}

{{-- <div class="col-12 form-group">
    <label class="form-control-label" for="input-page_type">{{ __('Page Type') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('page_type') ? 'has-danger' : '' }}">
        <select class="form-control" name="page_type" id="input-page_type" data-toggle="select">
            @foreach ($static_page::listPageTypes() as $value => $label)
                <option value="{{ $value }}" @selected(old('page_type', $static_page->page_type) == $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>
    @include('alerts.feedback', ['field' => 'page_type'])
</div> --}}

<div id="innerPageWrapper" class="col-12 px-0">
    @include('admin.components.tinymce', ['editors' => ['Content' => 'editor_content'], 'model' => $static_page])
</div>

{{-- <div id="customUrlWrapper" class="col-12 form-group">
    <label class="form-control-label" for="input-page_url">{{ __('URL') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('page_url') ? 'has-danger' : '' }}">
        <input type="url" name="page_url" id="input-page_url" class="form-control {{ $errors->has('page_url') ? 'is-invalid' : '' }}" placeholder="{{ __('e.g https://www.google.com.my') }}" value="{{ old('page_url', $static_page->page_url) }}">
    </div>
    @include('alerts.feedback', ['field' => 'page_url'])
</div> --}}

{{-- <div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Show on Menu') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="on_menu" id="input-on_menu" value="1" {{ old('on_menu', $static_page->on_menu) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div> --}}

{{-- <div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Show on Footer') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="on_footer" id="input-on_footer" value="1" {{ old('on_footer', $static_page->on_footer) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div> --}}

{{-- <div id="footerSectionWrapper" class="col-12 form-group">
    <label class="form-control-label" for="input-on_footer_section">{{ __('Footer Section') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('on_footer_section') ? 'has-danger' : '' }}">
        <select class="form-control" name="on_footer_section" id="input-on_footer_section" data-toggle="select">
            <option value="">{{ __('Please Select') }}</option>

            @foreach ($static_page::listFooterSections() as $value => $label)
                <option value="{{ $value }}" @selected(old('on_footer_section', $static_page->on_footer_section) == $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>
    @include('alerts.feedback', ['field' => 'on_footer_section'])
</div> --}}

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Status Active') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $static_page->is_active) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

{{-- @push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $('#input-title').on('input', function (ev) {
            @if (!$unsluggable)
            convertToSlug($(this).val());
            @endif
        });

        function convertToSlug(str) {
            str = str.replace(/[`~!@#$%^&*()_\-+=\[\]{};:'"\\|\/,.<>?\s]/g, ' ').toLowerCase();
            str = str.replace(/^\s+|\s+$/gm,'');
            str = str.replace(/\s+/g, '-');

            $('#input-slug').val(str);
        }

        function checkPageType() {
            $('#innerPageWrapper').hide();
            $('#customUrlWrapper').hide();

            let page_type = $('#input-page_type').val();

            if (page_type == "{{ $static_page::TYPE_INNER_PAGE }}") {
                $('#slugWrapper').show();
                $('#metaDescWrapper').show();
                $('#metaKeywordWrapper').show();
                $('#innerPageWrapper').show();
            } else {
                $('#slugWrapper').hide();
                $('#metaDescWrapper').hide();
                $('#metaKeywordWrapper').hide();
                $('#customUrlWrapper').show();
            }
        }

        $('#input-page_type').on('change', function() {
            checkPageType();
        });

        checkPageType();

        function checkOnFooter() {
            let is_checked = $('#input-on_footer').is(':checked');

            $('#footerSectionWrapper').hide();

            if (is_checked) {
                $('#footerSectionWrapper').show();
            }
        }

        $('#input-on_footer').on('change', function() {
            checkOnFooter();
        });

        checkOnFooter();
    </script>
@endpush --}}
