@extends('admin.layouts.base', [
    'title' => __('Create New Page'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-pager fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('static-page.index') }}">{{ __('Pages') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Create New') }}</li>

        @slot('buttons')
            <a href="{{ route('static-page.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('title', __('New Page'))
                    @slot('route', route('static-page.store'))

                    @include('admin.staticpage.form', ['static_page' => $static_page])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
