@php
    $menu->loadMissing('children');
    $children = $menu->children;
@endphp

<div class="list-group nested-sortable">
    @if ($children->isNotEmpty())
        @foreach ($children as $child)
            <div class="list-group-item border nested-padding " data-id="{{ $child->id }}">
                <div class="mt-2 ml-2">
                    <i class="fas fa-arrows-alt grabbing text-primary mr-2"></i>

                    <a href="{{ route('static-page.edit', $child) }}" class="mr-2">
                        <i class="fas fa-edit text-primary"></i>
                    </a>

                    <span>{{ $child->title }}</span>

                    @if (!$child->is_active)
                        <span class="badge badge-sm badge-danger ml-2">{{ __('Inactive') }}</span>
                    @endif
                </div>

                @include('admin.staticpage.child', ['menu' => $child])
            </div>
        @endforeach
    @endif
</div>
