@component('admin.components.card')
    @slot('title', __('Social'))
    @slot('class', 'pb-0')

    <div class="row">
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="social-linkedin">{{ __('Linkedin') }}</label>
            <div class="{{ $errors->has('social-linkedin') ? 'has-danger' : '' }}">
                <input type="url" name="social-linkedin" id="social-linkedin" class="form-control {{ $errors->has('social-linkedin') ? 'is-invalid' : '' }}" placeholder="{{ __('https://linkedin.com') }}" value="{{ old('social-linkedin', config('social.linkedin')) }}">
            </div>
            @include('alerts.feedback', ['field' => 'social-linkedin'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="social-facebook">{{ __('Facebook') }}</label>
            <div class="{{ $errors->has('social-facebook') ? 'has-danger' : '' }}">
                <input type="url" name="social-facebook" id="social-facebook" class="form-control {{ $errors->has('social-facebook') ? 'is-invalid' : '' }}" placeholder="{{ __('https://facebook.com') }}" value="{{ old('social-facebook', config('social.facebook')) }}">
            </div>
            @include('alerts.feedback', ['field' => 'social-facebook'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="social-instagram">{{ __('Instagram') }}</label>
            <div class="{{ $errors->has('social-instagram') ? 'has-danger' : '' }}">
                <input type="url" name="social-instagram" id="social-instagram" class="form-control {{ $errors->has('social-instagram') ? 'is-invalid' : '' }}" placeholder="{{ __('https://instagram.com') }}" value="{{ old('social-instagram', config('social.instagram')) }}">
            </div>
            @include('alerts.feedback', ['field' => 'social-instagram'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="social-youtube">{{ __('Youtube') }}</label>
            <div class="{{ $errors->has('social-youtube') ? 'has-danger' : '' }}">
                <input type="url" name="social-youtube" id="social-youtube" class="form-control {{ $errors->has('social-youtube') ? 'is-invalid' : '' }}" placeholder="{{ __('https://youtube.com') }}" value="{{ old('social-youtube', config('social.youtube')) }}">
            </div>
            @include('alerts.feedback', ['field' => 'social-youtube'])
        </div>
    </div>
@endcomponent
