@component('admin.components.card')
    @slot('title', __('Mail SMTP'))
    @slot('class', 'pb-0')

    <div class="row">
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-from-name">{{ __('Sender Name') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('mail-from-name') ? 'has-danger' : '' }}">
                <input type="text" name="mail-from-name" id="mail-from-name" class="form-control {{ $errors->has('mail-from-name') ? 'is-invalid' : '' }}" placeholder="{{ __('Sender Name') }}" value="{{ old('mail-from-name', config('mail.from.name')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'mail-from-name'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-from-address">{{ __('Sender Email') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('mail-from-address') ? 'has-danger' : '' }}">
                <input type="email" name="mail-from-address" id="mail-from-address" class="form-control {{ $errors->has('mail-from-address') ? 'is-invalid' : '' }}" placeholder="{{ __('Sender Email') }}" value="{{ old('mail-from-address', config('mail.from.address')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'mail-from-address'])
        </div>
        <div class="col-12 form-group">
            <hr class="my-0">
        </div>
        <div class="col-12 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-host">{{ __('Host') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('mail-mailers-smtp-host') ? 'has-danger' : '' }}">
                <input type="text" name="mail-mailers-smtp-host" id="mail-mailers-smtp-host" class="form-control {{ $errors->has('mail-mailers-smtp-host') ? 'is-invalid' : '' }}" placeholder="{{ __('Host') }}" value="{{ old('mail-mailers-smtp-host', config('mail.mailers.smtp.host')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'mail-mailers-smtp-host'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-port">{{ __('Port') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('mail-mailers-smtp-port') ? 'has-danger' : '' }}">
                <input type="tel" inputmode="numeric" name="mail-mailers-smtp-port" id="mail-mailers-smtp-port" class="form-control {{ $errors->has('mail-mailers-smtp-port') ? 'is-invalid' : '' }}" placeholder="{{ __('Port') }}" value="{{ old('mail-mailers-smtp-port', config('mail.mailers.smtp.port')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'mail-mailers-smtp-port'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-encryption">{{ __('Encryption') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('mail-mailers-smtp-encryption') ? 'has-danger' : '' }}">
                <input type="text" name="mail-mailers-smtp-encryption" id="mail-mailers-smtp-encryption" class="form-control {{ $errors->has('mail-mailers-smtp-encryption') ? 'is-invalid' : '' }}" placeholder="{{ __('Encryption') }}" value="{{ old('mail-mailers-smtp-encryption', config('mail.mailers.smtp.encryption')) }}" required>
            </div>
            @include('alerts.feedback', ['field' => 'mail-mailers-smtp-encryption'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-username">{{ __('Username') }}</label>
            <span class="form-text text-muted mt-0">{{ config('mail.mailers.smtp.username') ? mask(config('mail.mailers.smtp.username')) : 'N/A' }}</span>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-password">{{ __('Password') }}</label>
            <span class="form-text text-muted mt-0">{{ config('mail.mailers.smtp.password') ? mask(config('mail.mailers.smtp.password')) : 'N/A' }}</span>
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-username">{{ __('New Username') }}</label>
            <div class="{{ $errors->has('mail-mailers-smtp-username') ? 'has-danger' : '' }}">
                <input type="text" name="mail-mailers-smtp-username" id="mail-mailers-smtp-username" class="form-control {{ $errors->has('mail-mailers-smtp-username') ? 'is-invalid' : '' }}" placeholder="{{ __('Username') }}" value="{{ old('mail-mailers-smtp-username') }}">
            </div>
            @include('alerts.feedback', ['field' => 'mail-mailers-smtp-username'])
        </div>
        <div class="col-lg-6 form-group">
            <label class="form-control-label" for="mail-mailers-smtp-password">{{ __('New Password') }}</label>
            <div class="{{ $errors->has('mail-mailers-smtp-password') ? 'has-danger' : '' }}">
                <input type="text" name="mail-mailers-smtp-password" id="mail-mailers-smtp-password" class="form-control {{ $errors->has('mail-mailers-smtp-password') ? 'is-invalid' : '' }}" placeholder="{{ __('Password') }}" value="{{ old('mail-mailers-smtp-password') }}" autocomplete="off">
            </div>
            @include('alerts.feedback', ['field' => 'mail-mailers-smtp-password'])
        </div>
        <div class="col-12 form-group">
            <div class="text-center">
                <button id="testSMTP" type="button" class="btn btn-info" data-action="{{ route('setting.smtp') }}"><i class="fas fa-paper-plane mr-2"></i>{{ __('Test SMTP') }}</button>
            </div>
        </div>
    </div>
@endcomponent

@push('js')
    @bassetBlock('admin/js/setting-test-smtp.js')
        <script nonce="{{ basset_nonce('script') }}">
            $('#testSMTP').on('click', function() {
                var btn = $(this);
                var action = btn.data('action');
                var data = {};

                data.name = $('#mail-from-name').val();
                data.email = $('#mail-from-address').val();
                data.host = $('#mail-mailers-smtp-host').val();
                data.port = $('#mail-mailers-smtp-port').val();
                data.encryption = $('#mail-mailers-smtp-encryption').val();
                data.username = $('#mail-mailers-smtp-username').val();
                data.password = $('#mail-mailers-smtp-password').val();
                data.save = true;

                btn.prop('disabled', true);

                $.ajax({
                    url: action,
                    method: 'post',
                    data: data,
                    success: function (res) {
                        alert(res.message);
                        btn.prop('disabled', false);
                    },
                    error: function () {
                        alert(res.message);
                        btn.prop('disabled', false);
                    },
                    complete: function () {
                        btn.prop('disabled', false);
                    }
                });
            });
        </script>
    @endBassetBlock()
@endpush
