@component('admin.components.card')
    @slot('title', __('reCaptcha'))
    @slot('class', 'pb-0')

    <div class="row">
        <div class="col-12 form-group">
            <label class="form-control-label" for="recaptcha-api_site_key">{{ __('Site Key') }}</label>
            <span class="form-text text-muted mt-0">{{ config('recaptcha.api_site_key') ? mask(config('recaptcha.api_site_key')) : 'N/A' }}</span>
        </div>
        <div class="col-12 form-group">
            <label class="form-control-label" for="recaptcha-api_site_key">{{ __('New Site Key') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('recaptcha-api_site_key') ? 'has-danger' : '' }}">
                <input type="text" name="recaptcha-api_site_key" id="recaptcha-api_site_key" class="form-control {{ $errors->has('recaptcha-api_site_key') ? 'is-invalid' : '' }}" placeholder="{{ __('Site Key') }}" value="{{ old('recaptcha-api_site_key') }}">
            </div>
            @include('alerts.feedback', ['field' => 'recaptcha-api_site_key'])
        </div>
        <div class="col-12 form-group">
            <label class="form-control-label" for="recaptcha-api_secret_key">{{ __('Secret Key') }}</label>
            <span class="form-text text-muted mt-0">{{ config('recaptcha.api_secret_key') ? mask(config('recaptcha.api_secret_key')) : 'N/A' }}</span>
        </div>
        <div class="col-12 form-group">
            <label class="form-control-label" for="recaptcha-api_secret_key">{{ __('New Secret Key') }} <sup class="text-danger">*</sup></label>
            <div class="{{ $errors->has('recaptcha-api_secret_key') ? 'has-danger' : '' }}">
                <input type="text" name="recaptcha-api_secret_key" id="recaptcha-api_secret_key" class="form-control {{ $errors->has('recaptcha-api_secret_key') ? 'is-invalid' : '' }}" placeholder="{{ __('Secret Key') }}" value="{{ old('recaptcha-api_secret_key') }}">
            </div>
            @include('alerts.feedback', ['field' => 'recaptcha-api_secret_key'])
        </div>
    </div>
@endcomponent
